/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.labeldecorators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class LabelDecorationContribution
extends VisualsContribution {
    LabelDecorationRule labelDecorationRule;

    public LabelDecorationContribution(NodeType nodeType, Test test, LabelDecorationRule labelDecorationRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!labelDecorationRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Label decoration rule is not compatible with the content type.");
        }
        this.labelDecorationRule = labelDecorationRule;
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.labelDecorationRule.getLabelDecorator(graph, content);
            }
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

