/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.images;

import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class ImageContribution
extends VisualsContribution {
    ImageRule imageRule;

    public ImageContribution(NodeType nodeType, Test test, ImageRule imageRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!imageRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("image rule is not compatible with the content type.");
        }
        this.imageRule = imageRule;
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.imageRule.getImage(graph, content);
            }
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

