/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.imagedecorators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class ImageDecorationContribution
extends VisualsContribution {
    ImageDecorationRule imageDecorationRule;

    public ImageDecorationContribution(NodeType nodeType, Test test, ImageDecorationRule imageDecorationRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!imageDecorationRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Image decoration rule is not compatible with the content type.");
        }
        this.imageDecorationRule = imageDecorationRule;
    }

    public ImageDecorator getImageDecorator(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.imageDecorationRule.getImageDecorator(graph, content);
            }
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

