/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DropActionContribution;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.OrderedNodeTypeMultiMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class DndBrowseContext {
    OrderedNodeTypeMultiMap<DropActionContribution> dropActionContributions = new OrderedNodeTypeMultiMap();

    private DndBrowseContext() {
    }

    public static DndBrowseContext create(ReadGraph g, Collection<Resource> browseContextResources) throws DatabaseException, InvalidContribution {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        DndBrowseContext browseContext = new DndBrowseContext();
        for (Resource browseContextResource : DndBrowseContext.findSubcontexts(g, browseContextResources)) {
            for (Resource actionContributionResource : g.getObjects(browseContextResource, vr.BrowseContext_HasDropActionContribution)) {
                DropActionContribution.load(g, actionContributionResource, browseContext.dropActionContributions);
            }
        }
        return browseContext;
    }

    private static Collection<Resource> findSubcontexts(ReadGraph g, Collection<Resource> browseContexts) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        HashSet<Resource> result = new HashSet<Resource>(browseContexts);
        ArrayList<Resource> stack = new ArrayList<Resource>(browseContexts);
        while (!stack.isEmpty()) {
            Resource cur = stack.remove(stack.size() - 1);
            for (Resource sc : g.getObjects(cur, vr.BrowseContext_Includes)) {
                if (!result.add(sc)) continue;
                stack.add(sc);
            }
        }
        return result;
    }

    private static NodeType getNodeType(ReadGraph graph, NodeContext parent) throws DatabaseException {
        Object input;
        NodeType nodeType = (NodeType)parent.getConstant(NodeType.TYPE);
        if (nodeType == null && (input = parent.getConstant(BuiltinKeys.INPUT)) instanceof Resource) {
            nodeType = EntityNodeType.getNodeTypeFor(graph, (Resource)input);
        }
        return nodeType;
    }

    public Runnable getAction(ReadGraph graph, NodeContext target, Object source) throws DatabaseException {
        NodeType nodeType = DndBrowseContext.getNodeType(graph, target);
        if (nodeType == null) {
            return null;
        }
        for (DropActionContribution contribution : this.dropActionContributions.get(graph, nodeType)) {
            Runnable action = contribution.getAction(graph, target, source);
            if (action == null) continue;
            return action;
        }
        return null;
    }
}

