/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoInverseException;

public class RelationChildRule
implements ChildRule {
    Resource relation;
    Test test;

    public RelationChildRule(Resource relation, Test test) {
        this.relation = relation;
        this.test = test;
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        ArrayList<Resource> result = graph.getObjects((Resource)parent, this.relation);
        if (this.test != null) {
            ArrayList<Resource> filtered = new ArrayList<Resource>(result.size());
            for (Resource r : result) {
                if (!this.test.test(graph, r)) continue;
                filtered.add(r);
            }
            result = filtered;
        }
        return result;
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        try {
            if (child instanceof Resource) {
                Resource inverse = graph.getInverse(this.relation);
                return graph.getObjects((Resource)child, inverse);
            }
        }
        catch (NoInverseException noInverseException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }
}

