/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.check;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class CheckedStateContribution
extends VisualsContribution {
    CheckedStateRule stateRule;

    public CheckedStateContribution(NodeType nodeType, Test test, CheckedStateRule stateRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!stateRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("image rule is not compatible with the content type.");
        }
        this.stateRule = stateRule;
    }

    public CheckedState getCheckedState(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.stateRule.getCheckedState(graph, content);
            }
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }
}

