/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.browsecontexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.ActionBrowseContextRequest;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContextRequest;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;

public final class BrowseContexts {
    public static String[] toSortedURIs(ReadGraph graph, Collection<Resource> rs) throws DatabaseException {
        Object[] result = new String[rs.size()];
        int i = 0;
        for (Resource r : rs) {
            String uri = graph.getPossibleURI(r);
            if (uri == null) continue;
            result[i++] = uri;
        }
        if (i > 1) {
            Arrays.sort(result, 0, i);
        }
        return i < result.length ? (String[])Arrays.copyOf(result, i) : result;
    }

    public static BrowseContext toBrowseContext(RequestProcessor processor, String[] uris) throws DatabaseException {
        return (BrowseContext)processor.syncRequest((Read)new URIsToBrowseContext(Arrays.asList(uris)), (Listener)TransientCacheListener.instance());
    }

    public static ActionBrowseContext toActionBrowseContext(RequestProcessor processor, String[] uris) throws DatabaseException {
        return (ActionBrowseContext)processor.syncRequest((Read)new URIsToActionBrowseContext(Arrays.asList(uris)), (Listener)TransientCacheListener.instance());
    }

    public static class ResourcesToURIs
    extends UnaryRead<Collection<Resource>, List<String>> {
        public ResourcesToURIs(Collection<Resource> parameter) {
            super(parameter);
        }

        public List<String> perform(ReadGraph graph) throws DatabaseException {
            ArrayList<String> result = new ArrayList<String>(((Collection)this.parameter).size());
            for (Resource r : (Collection)this.parameter) {
                String uri = graph.getPossibleURI(r);
                if (uri == null) continue;
                result.add(uri);
            }
            return result;
        }
    }

    public static class URIsToActionBrowseContext
    extends UnaryRead<List<String>, ActionBrowseContext> {
        public URIsToActionBrowseContext(List<String> parameter) {
            super(parameter);
        }

        public ActionBrowseContext perform(ReadGraph graph) throws DatabaseException {
            Collection resources = (Collection)graph.syncRequest((Read)new URIsToResources((List)this.parameter));
            return resources.isEmpty() ? null : (ActionBrowseContext)graph.syncRequest((Read)new ActionBrowseContextRequest(resources));
        }
    }

    public static class URIsToBrowseContext
    extends UnaryRead<List<String>, BrowseContext> {
        public URIsToBrowseContext(List<String> parameter) {
            super(parameter);
        }

        public BrowseContext perform(ReadGraph graph) throws DatabaseException {
            Collection resources = (Collection)graph.syncRequest((Read)new URIsToResources((List)this.parameter));
            return resources.isEmpty() ? null : (BrowseContext)graph.syncRequest((Read)new BrowseContextRequest(resources));
        }
    }

    public static class URIsToResources
    extends UnaryRead<List<String>, Collection<Resource>> {
        public URIsToResources(List<String> parameter) {
            super(parameter);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            ArrayList<Resource> result = new ArrayList<Resource>(((List)this.parameter).size());
            for (String uri : (List)this.parameter) {
                Resource r = graph.getPossibleResource(uri);
                if (r == null) continue;
                result.add(r);
            }
            return result;
        }
    }
}

