/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.CategorizedAction;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ActionContribution {
    NodeType nodeType;
    Test isVisible;
    Test isEnabled;
    String label;
    ActionFactory actionFactory;
    IActionCategory category;
    ImageDescriptor image;

    public ActionContribution(NodeType nodeType, Test isVisible, Test isEnabled, String label, ActionFactory actionFactory, IActionCategory category, ImageDescriptor image) {
        this.nodeType = nodeType;
        this.isVisible = isVisible;
        this.isEnabled = isEnabled;
        this.label = label;
        this.actionFactory = actionFactory;
        this.category = category;
        this.image = image;
    }

    public static void load(ReadGraph g, Resource r, NodeTypeMultiMap<ActionContribution> contributions) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        Resource isVisibleResource = g.getPossibleObject(r, vr.ActionContribution_IsVisibleIf);
        Test isVisible = isVisibleResource == null ? null : (Test)g.adapt(isVisibleResource, Test.class);
        Resource isEnabledResource = g.getPossibleObject(r, vr.ActionContribution_IsEnabledIf);
        Test isEnabled = isEnabledResource == null ? null : (Test)g.adapt(isEnabledResource, Test.class);
        String label = NameUtils.getSafeLabel((ReadGraph)g, (Resource)r);
        ActionFactory actionFactory = (ActionFactory)g.adapt(g.getSingleObject(r, vr.ActionContribution_HasAction), ActionFactory.class);
        Resource categoryResource = g.getPossibleObject(r, vr.ActionContribution_HasCategory);
        IActionCategory category = categoryResource == null ? null : (IActionCategory)g.adapt(categoryResource, IActionCategory.class);
        Resource imageResource = g.getPossibleObject(r, vr.ActionContribution_HasImage);
        ImageDescriptor image = imageResource == null ? null : (ImageDescriptor)g.adapt(imageResource, ImageDescriptor.class);
        for (Resource nodeTypeResource : g.getObjects(r, vr.ActionContribution_HasNodeType)) {
            NodeType nodeType = (NodeType)g.adapt(nodeTypeResource, NodeType.class);
            ActionContribution contribution = new ActionContribution(nodeType, isVisible, isEnabled, label, actionFactory, category, image);
            contributions.put(nodeType, contribution);
        }
    }

    public CategorizedAction getAction(ReadGraph graph, NodeContext context, Collection<NodeContext> all) {
        block5: {
            Runnable runnable;
            Object content;
            block6: {
                content = context.getConstant(BuiltinKeys.INPUT);
                try {
                    if (this.isVisible != null && !this.isVisible.test(graph, content)) break block5;
                    ArrayList<Object> allContents = new ArrayList<Object>();
                    for (NodeContext ctx : all) {
                        allContents.add(ctx.getConstant(BuiltinKeys.INPUT));
                    }
                    Runnable runnable2 = runnable = this.actionFactory instanceof ActionFactory2 ? ((ActionFactory2)this.actionFactory).create(allContents) : this.actionFactory.create(content);
                    if (runnable != null) break block6;
                    return null;
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                    return null;
                }
            }
            Action action = new Action(this.label){

                public void run() {
                    runnable.run();
                }
            };
            action.setId(runnable.getClass().getName());
            action.setEnabled(this.isEnabled == null || this.isEnabled.test(graph, content));
            if (this.image != null) {
                action.setImageDescriptor(this.image);
            }
            return new CategorizedAction(action, this.category);
        }
        return null;
    }
}

