/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.simantics.project.management.ServerManager;
import org.simantics.utils.FileUtils;

public class ServerManagerFactory {
    static ServerManager cached;

    public static ServerManager createOSGI() throws IOException, RuntimeException {
        try {
            ClassLoader cl = ServerManager.class.getClassLoader();
            Class<?> Platform_class = cl.loadClass("org.eclipse.core.runtime.Platform");
            Method Platform_getBundle = Platform_class.getMethod("getBundle", String.class);
            Object bundle = Platform_getBundle.invoke(null, "org.simantics.db.build");
            if (bundle == null) {
                throw new RuntimeException("Bundle org.simantics.db.build not found.");
            }
            Class<?> Bundle_class = cl.loadClass("org.osgi.framework.Bundle");
            Method Bundle_getEntry = Bundle_class.getMethod("getEntry", String.class);
            URL db_build_url = (URL)Bundle_getEntry.invoke(bundle, "/");
            Class<?> FileLocator_class = cl.loadClass("org.eclipse.core.runtime.FileLocator");
            Method FileLocator_toFileURL = FileLocator_class.getMethod("toFileURL", URL.class);
            URL db_build_file_url = (URL)FileLocator_toFileURL.invoke(null, db_build_url);
            String buildFile = URLDecoder.decode(db_build_file_url.getPath(), "UTF-8");
            File db_build_file = new File(buildFile);
            return new ServerManager(db_build_file);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerManager createPOJO() throws IOException {
        File driverDir;
        String tempPath = System.getenv("tmp");
        if (tempPath == null) {
            tempPath = "c:/temp/";
        }
        if (!(driverDir = new File(String.valueOf(tempPath) + "/core_drivers")).exists()) {
            System.out.println("Extracting Core drivers to " + driverDir);
            driverDir.mkdirs();
            ServerManagerFactory.extractDrivers(driverDir);
        } else {
            System.out.println("Loading Core drivers from " + driverDir);
        }
        return new ServerManager(driverDir);
    }

    public static ServerManager createPOJO(File driverDir) throws IOException {
        return new ServerManager(driverDir);
    }

    public static boolean isOSGi() {
        try {
            ServerManager.class.getClassLoader().loadClass("org.osgi.framework.Bundle");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static synchronized ServerManager getServerManager() {
        if (cached != null) {
            return cached;
        }
        try {
            try {
                return ServerManagerFactory.createOSGI();
            }
            catch (RuntimeException e) {
                return ServerManagerFactory.createPOJO();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void extractDrivers(File path) throws IOException {
        InputStream is = ServerManager.class.getResource("org.simantics.db.build.zip").openStream();
        try {
            ServerManagerFactory.extractZip(is, path);
        }
        finally {
            is.close();
        }
    }

    private static void extractZip(InputStream zipInput, File dst) throws IOException {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        byte[] buf = new byte[8192];
        ZipInputStream zis = new ZipInputStream(zipInput);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            myLogger.debug((Object)("Extracting " + name));
            File file = new File(dst, name);
            if (entry.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                try {
                    int n = 0;
                    while ((n = zis.read(buf, 0, buf.length)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                }
                finally {
                    fileoutputstream.close();
                }
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        zis.close();
    }
}

