/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.RequestProcessor;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerEx;
import org.simantics.db.ServerI;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.DatabaseManagementResource;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.utils.FileUtils;

public class ServerManager {
    public static final Properties DEFAULT = new Properties();
    Driver driver;
    File applicationDir;
    boolean deleteApplicationDir;
    Map<File, ServerHost> servers = Collections.synchronizedMap(new HashMap());

    static {
        DEFAULT.setProperty("user", "Default User");
        DEFAULT.setProperty("password", "");
    }

    public ServerManager(File applicationDirectory) throws IOException {
        try {
            Class.forName("fi.vtt.simantics.procore.ProCoreDriver");
            this.driver = Manager.getDriver((String)"procore");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("fi.vtt.simantics.procore.ProCoreDriver driver was not found", e);
        }
        this.applicationDir = applicationDirectory;
        this.deleteApplicationDir = false;
        if (!this.applicationDir.exists()) {
            throw new RuntimeException("Init error, application directory " + this.applicationDir + " does not exist");
        }
    }

    public void createDatabase(File databaseDirectory, GraphBundle ... initialGraphs) throws DatabaseException {
        this.createDatabase(databaseDirectory, 0, initialGraphs);
    }

    public void createDatabase(File databaseDirectory, int port, final GraphBundle ... initialGraphs) throws DatabaseException {
        try {
            databaseDirectory.mkdirs();
            File configFile = new File(databaseDirectory, "procore.config.procore");
            ServerManager.createServerConfig(configFile, port);
            Logger myLogger = Logger.getLogger(ServerManager.class);
            myLogger.debug((Object)("Creating database to " + databaseDirectory));
            ServerEx server1 = this.getServer(databaseDirectory);
            server1.start();
            try {
                String clientId = "client";
                IProduct product = Platform.getProduct();
                if (product != null) {
                    clientId = product.getApplication();
                }
                Properties info = new Properties();
                info.setProperty("user", "Default User");
                info.setProperty("password", "");
                info.setProperty("omitbuiltins", "");
                info.setProperty("clientDir", databaseDirectory.getAbsolutePath());
                info.setProperty("clientId", clientId);
                ServiceLocator service = server1.getServiceLocator(info);
                CoreInitialization.initializeBuiltins((ServiceLocator)service);
                if (initialGraphs.length > 0) {
                    Session session = server1.createSession(info);
                    ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                    GraphBundle[] graphBundleArray = initialGraphs;
                    int n = initialGraphs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GraphBundle tg = graphBundleArray[n2];
                        long[] resourceArray = CoreInitialization.initializeGraph((Session)session, (TransferableGraph1)tg.getGraph());
                        tg.setResourceArray(resourceArray);
                        ++n2;
                    }
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                    Properties p = new Properties(DEFAULT);
                    p.setProperty("clientDir", databaseDirectory.getAbsolutePath());
                    p.setProperty("clientId", clientId);
                    session = server1.createSession(p);
                    ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                    DatabaseManagementResource.getInstance((RequestProcessor)session);
                    session.syncRequest((WriteOnly)new WriteOnlyRequest(){

                        public void perform(WriteOnlyGraph graph) throws DatabaseException {
                            graph.newClusterSet(graph.getRootLibrary());
                            DatabaseManagement mgt = new DatabaseManagement();
                            GraphBundle[] graphBundleArray = initialGraphs;
                            int n = initialGraphs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GraphBundle tg = graphBundleArray[n2];
                                mgt.createGraphBundle(graph, tg);
                                ++n2;
                            }
                            graph.flushCluster();
                        }
                    });
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                }
            }
            finally {
                server1.stop();
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void createDatabase(File databaseDirectory, ServerAddress remoteServer, final GraphBundle ... initialGraphs) throws DatabaseException {
        try {
            databaseDirectory.mkdirs();
            File configFile = new File(databaseDirectory, "procore.config.procore");
            ServerManager.createServerConfig(configFile, remoteServer.getAddress().getPort());
            Logger myLogger = Logger.getLogger(ServerManager.class);
            myLogger.debug((Object)("Creating dummy database to " + databaseDirectory));
            ServerEx server1 = this.getServer(remoteServer);
            server1.start();
            try {
                String clientId = "client";
                IProduct product = Platform.getProduct();
                if (product != null) {
                    clientId = product.getApplication();
                }
                Properties info = new Properties();
                info.setProperty("user", "Default User");
                info.setProperty("password", "");
                info.setProperty("omitbuiltins", "");
                info.setProperty("clientDir", databaseDirectory.getAbsolutePath());
                info.setProperty("clientId", clientId);
                ServiceLocator service = server1.getServiceLocator(info);
                CoreInitialization.initializeBuiltins((ServiceLocator)service);
                if (initialGraphs.length > 0) {
                    Session session = server1.createSession(info);
                    ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                    GraphBundle[] graphBundleArray = initialGraphs;
                    int n = initialGraphs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GraphBundle tg = graphBundleArray[n2];
                        long[] resourceArray = CoreInitialization.initializeGraph((Session)session, (TransferableGraph1)tg.getGraph());
                        tg.setResourceArray(resourceArray);
                        ++n2;
                    }
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                    Properties p = new Properties(DEFAULT);
                    p.setProperty("clientDir", databaseDirectory.getAbsolutePath());
                    p.setProperty("clientId", clientId);
                    session = server1.createSession(p);
                    ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                    DatabaseManagementResource.getInstance((RequestProcessor)session);
                    session.syncRequest((WriteOnly)new WriteOnlyRequest(){

                        public void perform(WriteOnlyGraph graph) throws DatabaseException {
                            DatabaseManagement mgt = new DatabaseManagement();
                            GraphBundle[] graphBundleArray = initialGraphs;
                            int n = initialGraphs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GraphBundle tg = graphBundleArray[n2];
                                mgt.createGraphBundle(graph, tg);
                                ++n2;
                            }
                            graph.flushCluster();
                        }
                    });
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                }
            }
            finally {
                server1.stop();
            }
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void createCheckout(ServerAddress server, File path) throws DatabaseException {
        Manager.checkout((Driver)this.driver, (String)this.applicationDir.getAbsolutePath(), (String)path.getAbsolutePath(), (ServerAddress)server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEx getServer(File databaseDirectory) throws DatabaseException {
        File file = databaseDirectory.getAbsoluteFile();
        ServerHost host = null;
        Map<File, ServerHost> map = this.servers;
        synchronized (map) {
            host = this.servers.get(file);
            if (host == null) {
                File ucDir = Manager.getUndocoreDirectory((File)this.applicationDir);
                ServerI server = this.driver.getServer(ucDir, databaseDirectory);
                try {
                    host = new ServerHost(server, databaseDirectory);
                }
                catch (IOException e) {
                    throw new DatabaseException("Failed to load procore.config.procore", (Throwable)e);
                }
                this.servers.put(file, host);
            }
        }
        ProxyServer proxy = new ProxyServer(host);
        return proxy;
    }

    public ServerEx getServer(ServerAddress endpoint) {
        return new ConnectedServer(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<File, ServerHost> map = this.servers;
        synchronized (map) {
            for (ServerHost host : this.servers.values()) {
                ServerI server = host.actual;
                try {
                    if (!server.isActive()) continue;
                    server.stop();
                }
                catch (DatabaseException e) {
                    Logger myLogger = Logger.getLogger(ServerManager.class);
                    myLogger.error((Object)e);
                }
            }
            this.servers.clear();
        }
        if (this.deleteApplicationDir) {
            FileUtils.deleteDir((File)this.applicationDir);
            this.deleteApplicationDir = false;
            this.applicationDir = null;
        }
    }

    public static int getFreeEphemeralPort() {
        while (true) {
            int n;
            block8: {
                Socket s2 = null;
                try {
                    s2 = new Socket();
                    s2.bind(null);
                    n = s2.getLocalPort();
                    if (s2 == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (s2 != null) {
                            s2.close();
                        }
                        throw throwable;
                    }
                    catch (BindException s2) {
                        continue;
                    }
                    catch (Throwable e) {
                        throw new Error(e);
                    }
                }
                s2.close();
            }
            return n;
            break;
        }
    }

    public static void createServerConfig(File file, int port) throws IOException {
        InputStream is = ServerManager.class.getResourceAsStream("server_template.cnfg");
        byte[] data = StreamUtil.readFully((InputStream)is);
        is.close();
        FileOutputStream os = new FileOutputStream(file, false);
        os.write(data);
        Properties properties = new Properties();
        String portS = "" + (port == 0 ? ServerManager.getFreeEphemeralPort() : port);
        properties.put("common_port", portS);
        System.err.println("starting server in " + portS);
        properties.store(os, "# automatically generated properties");
        os.close();
    }

    public class ConnectedServer
    implements ServerEx {
        ServerAddress endpoint;

        public ConnectedServer(ServerAddress endpoint) {
            this.endpoint = endpoint;
        }

        public void start() throws DatabaseException {
        }

        public void stop() throws DatabaseException {
        }

        public boolean isActive() {
            return true;
        }

        public int getPort() {
            return this.endpoint.getAddress().getPort();
        }

        public Session createSession(Properties properties) throws DatabaseException {
            return ServerManager.this.driver.connect(this.endpoint, properties);
        }

        public ServiceLocator getServiceLocator(Properties info) throws DatabaseException {
            return ServerManager.this.driver.connect2(this.endpoint, info);
        }

        public String execute(String command) throws DatabaseException {
            return null;
        }
    }

    public class ProxyServer
    implements ServerEx {
        boolean running;
        ServerHost actual;

        public ProxyServer(ServerHost actual) {
            this.actual = actual;
        }

        public File getDatabase() {
            return this.actual.getDatabase();
        }

        public Properties getProperties() {
            return this.actual.getProperties();
        }

        public int getPort() throws DatabaseException {
            return this.actual.getPort();
        }

        public boolean isActive() {
            return this.running && this.actual.isActive();
        }

        public void start() throws DatabaseException {
            if (this.running) {
                return;
            }
            this.actual.start();
            this.running = true;
        }

        public void stop() throws DatabaseException {
            if (!this.running) {
                return;
            }
            this.actual.stop();
            this.running = false;
        }

        public Session createSession(Properties properties) throws DatabaseException {
            int port = this.actual.getPort();
            ServerAddress serverReference = new ServerAddress("127.0.0.1", port);
            return ServerManager.this.driver.connect(serverReference, properties);
        }

        public ServiceLocator getServiceLocator(Properties info) throws DatabaseException {
            int port = this.actual.getPort();
            ServerAddress serverReference = new ServerAddress("127.0.0.1", port);
            return ServerManager.this.driver.connect2(serverReference, info);
        }

        public String execute(String command) throws DatabaseException {
            return this.actual.execute(command);
        }
    }

    class ServerHost
    implements ServerEx {
        File database;
        ServerI actual;
        int refCount = 0;
        Properties properties;

        public ServerHost(ServerI actual, File database) throws IOException {
            this.actual = actual;
            this.database = database;
            this.properties = new Properties();
            if (database == null) {
                return;
            }
            File file = new File(database, "procore.config.procore");
            FileReader fr = new FileReader(file);
            try {
                this.properties.load(fr);
            }
            finally {
                fr.close();
            }
        }

        public File getDatabase() {
            return this.database;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public int getPort() throws DatabaseException {
            return this.actual.getPort();
        }

        public boolean isActive() {
            try {
                return this.actual.isActive();
            }
            catch (DatabaseException e) {
                return false;
            }
        }

        public void start() throws DatabaseException {
            boolean isRunning = this.actual.isActive();
            if (!isRunning) {
                this.actual.start();
            }
            ++this.refCount;
        }

        public void stop() throws DatabaseException {
            if (this.refCount == 0) {
                throw new DatabaseException("Trying to stop a standing process.");
            }
            if (this.refCount > 1) {
                --this.refCount;
                return;
            }
            if (this.actual.isActive()) {
                --this.refCount;
                this.actual.stop();
            }
        }

        public Session createSession(Properties properties) throws DatabaseException {
            int port = this.actual.getPort();
            ServerAddress serverReference = new ServerAddress("127.0.0.1", port);
            return ServerManager.this.driver.connect(serverReference, properties);
        }

        public ServiceLocator getServiceLocator(Properties info) throws DatabaseException {
            int port = this.actual.getPort();
            ServerAddress serverReference = new ServerAddress("127.0.0.1", port);
            return ServerManager.this.driver.connect2(serverReference, info);
        }

        public String execute(String command) throws DatabaseException {
            return this.actual.execute(command);
        }
    }
}

