/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.simantics.project.management.P2Util;
import org.simantics.utils.strings.EString;

public class SPMUtil {
    private static IProvisioningAgent localAgent;
    private static File workspacesLocation;
    private static File coresLocation;

    public static URI getRepositoryLocation() {
        return Platform.getLocation().append("repository").toFile().toURI();
    }

    public static synchronized IProvisioningAgent getLocalAgent() throws ProvisionException {
        if (localAgent == null) {
            IPath agentLocation = Platform.getLocation().append("P2");
            localAgent = P2Util.createAgent(agentLocation);
        }
        return localAgent;
    }

    public static String[] getSourceLocations() {
        IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String yyy = Platform.getPreferencesService().getString("org.simantics.project", "repository_sources", "", scopes);
        return EString.explode((String)yyy, (String)"\n");
    }

    public static synchronized File getWorkspacesLocation() {
        if (workspacesLocation == null) {
            workspacesLocation = new File(Platform.getLocation().toFile(), "workspaces");
        }
        return workspacesLocation;
    }

    public static synchronized File getCoresLocation() {
        if (coresLocation == null) {
            coresLocation = new File(Platform.getLocation().toFile(), "cores");
        }
        return coresLocation;
    }

    public static boolean isWorkspace(File path) {
        if (!path.exists()) {
            return false;
        }
        File db = new File(path, "db");
        if (!db.exists()) {
            return false;
        }
        if (!SPMUtil.isDatabase(db)) {
            return false;
        }
        File props = new File(path, "simantics.cfg");
        return props.exists();
    }

    public static boolean isDatabase(File path) {
        File config = new File(path, "procore.config.procore");
        return config.exists();
    }
}

