/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.ui.query.RequiredIUsQuery;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;

public class ProvisioningUtil {
    private static IRequirement IS_FEATURE_REQUIREMENT = new RequiredCapability("org.eclipse.equinox.p2.eclipse.type", "feature", null, null, false, false, false);

    public static void getAllRequirements(IInstallableUnit iu, IQueryable<IInstallableUnit> repo, Set<IInstallableUnit> result) {
        if (result.contains(iu)) {
            return;
        }
        result.add(iu);
        RequiredIUsQuery reqsQuery = new RequiredIUsQuery(iu);
        for (IInstallableUnit _iu : repo.query((IQuery)reqsQuery, null).toSet()) {
            if (result.contains(_iu)) continue;
            ProvisioningUtil.getAllRequirements(_iu, repo, result);
        }
    }

    public static Collection<IInstallableUnit> getInstallableUnits(IMetadataRepository repo) {
        IQuery query = QueryUtil.createIUAnyQuery();
        IQueryResult matches = repo.query(query, null);
        return matches.toUnmodifiableSet();
    }

    public static boolean isCategory(IInstallableUnit iu) {
        String PROP_TYPE_CATEGORY = "org.eclipse.equinox.p2.type.category";
        String value = iu.getProperty(PROP_TYPE_CATEGORY);
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    public static boolean isFragment(IInstallableUnit iu) {
        return iu instanceof IInstallableUnitFragment;
    }

    public static boolean isGroup(IInstallableUnit iu) {
        String PROP_TYPE_GROUP = "org.eclipse.equinox.p2.type.group";
        String value = iu.getProperty(PROP_TYPE_GROUP);
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    public static boolean isPatch(IInstallableUnit iu) {
        String PROP_TYPE_PATCH = "org.eclipse.equinox.p2.type.patch";
        String value = iu.getProperty(PROP_TYPE_PATCH);
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    public static boolean isFeature(IInstallableUnit iu) {
        return iu.satisfies(IS_FEATURE_REQUIREMENT);
    }

    public static boolean isGraph(IInstallableUnit iu, IMetadataRepository metadata, IArtifactRepository arts) throws IOException {
        Collection artifacts = iu.getArtifacts();
        for (IArtifactKey key : artifacts) {
            if (!ProvisioningUtil.isGraphArtifact(arts, key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGraphArtifact(IArtifactRepository repo, IArtifactKey key) throws IOException {
        return ProvisioningUtil.hasFile(repo, key, "graph.tg");
    }

    public static boolean hasFile(IArtifactRepository repo, IArtifactKey key, String filename) throws IOException {
        boolean isBundle = key.getClassifier().equals("osgi.bundle");
        if (!isBundle) {
            return false;
        }
        IArtifactDescriptor[] iArtifactDescriptorArray = repo.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
            if (repo instanceof IFileArtifactRepository) {
                IFileArtifactRepository filerepo = (IFileArtifactRepository)repo;
                File f = filerepo.getArtifactFile(key);
                if (!f.exists()) {
                    return false;
                }
                boolean isJar = f.getName().toLowerCase().endsWith(".jar");
                if (!isJar) {
                    return false;
                }
                JarFile jf = new JarFile(f);
                try {
                    Enumeration<JarEntry> enm = jf.entries();
                    while (enm.hasMoreElements()) {
                        JarEntry entry = enm.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.equals(filename)) continue;
                        return true;
                    }
                }
                finally {
                    jf.close();
                }
            } else {
                int size = Integer.valueOf((String)desc.getProperties().get("download.size"));
                ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
                repo.getArtifact(desc, (OutputStream)bos, null);
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                JarInputStream jis = new JarInputStream(bis);
                JarEntry entry = jis.getNextJarEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.equals(filename)) {
                        return true;
                    }
                    entry = jis.getNextJarEntry();
                }
            }
            ++n2;
        }
        return false;
    }

    public static InputStream getFile(IArtifactRepository repo, IArtifactKey key, String filename) throws IOException {
        boolean isBundle = key.getClassifier().equals("osgi.bundle");
        if (!isBundle) {
            return null;
        }
        IArtifactDescriptor[] iArtifactDescriptorArray = repo.getArtifactDescriptors(key);
        int n = iArtifactDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor desc = iArtifactDescriptorArray[n2];
            if (repo instanceof IFileArtifactRepository) {
                IFileArtifactRepository filerepo = (IFileArtifactRepository)repo;
                File f = filerepo.getArtifactFile(key);
                if (!f.exists()) {
                    return null;
                }
                boolean isJar = f.getName().toLowerCase().endsWith(".jar");
                if (!isJar) {
                    return null;
                }
                JarFile jf = new JarFile(f);
                try {
                    Enumeration<JarEntry> enm = jf.entries();
                    while (enm.hasMoreElements()) {
                        JarEntry entry = enm.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.equals(filename)) continue;
                        InputStream is = jf.getInputStream(entry);
                        byte[] data = StreamUtil.readFully((InputStream)is);
                        is.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                        return byteArrayInputStream;
                    }
                }
                finally {
                    jf.close();
                }
            } else {
                int size = Integer.valueOf((String)desc.getProperties().get("download.size"));
                ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
                repo.getArtifact(desc, (OutputStream)bos, null);
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                JarInputStream jis = new JarInputStream(bis);
                JarEntry entry = jis.getNextJarEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.equals(filename)) {
                        return jis;
                    }
                    entry = jis.getNextJarEntry();
                }
            }
            ++n2;
        }
        return null;
    }

    public static Manifest getManifest(IArtifactRepository repo, IArtifactKey key) throws IOException {
        InputStream is = ProvisioningUtil.getFile(repo, key, "META-INF/MANIFEST.MF");
        if (is == null) {
            return null;
        }
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            is.close();
        }
    }

    public static Manifest getSimanticsManifest(IArtifactRepository repo, IArtifactKey key) throws IOException {
        InputStream is = ProvisioningUtil.getFile(repo, key, "META-INF/SIMANTICS.MF");
        if (is == null) {
            return null;
        }
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            is.close();
        }
    }

    public static IArtifactKey[] getAllArtifactKeys(IArtifactRepository repo) {
        return (IArtifactKey[])repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).toArray(IArtifactKey.class);
    }

    public static void getUserInstallables(IArtifactRepository repo, Collection<String> result) throws IOException {
        IArtifactKey[] keys;
        IArtifactKey[] iArtifactKeyArray = keys = (IArtifactKey[])repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).toArray(IArtifactKey.class);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            Manifest mf = ProvisioningUtil.getSimanticsManifest(repo, key);
            if (mf != null) {
                String bundleId = mf.getMainAttributes().getValue("Simantics-Feature-Bundle");
                result.add(bundleId);
            }
            ++n2;
        }
    }

    public static GraphBundle getGraphBundle(IArtifactRepository repo, IArtifactKey key, IInstallableUnit iu) throws TransferableGraphException {
        String name = ProvisioningUtil.getName(iu);
        TransferableGraph1 tg = ProvisioningUtil.getTransferableGraph(repo, key);
        return new GraphBundleEx(name, tg, key.getId(), key.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransferableGraph1 getTransferableGraph(IArtifactRepository repo, IArtifactKey key) throws TransferableGraphException {
        boolean isBundle = key.getClassifier().equals("osgi.bundle");
        if (!isBundle) {
            throw new TransferableGraphException("Artifact Key is not osgi.bundle");
        }
        IArtifactDescriptor[] iArtifactDescriptorArray = repo.getArtifactDescriptors(key);
        if (iArtifactDescriptorArray.length == 0) throw new TransferableGraphException(".tg file was not found in " + key);
        IArtifactDescriptor desc = iArtifactDescriptorArray[0];
        if (repo instanceof IFileArtifactRepository) {
            IFileArtifactRepository filerepo = (IFileArtifactRepository)repo;
            File f = filerepo.getArtifactFile(key);
            if (!f.exists()) {
                throw new TransferableGraphException(f + " not found");
            }
            boolean isJar = f.getName().toLowerCase().endsWith(".jar");
            if (!isJar) {
                throw new TransferableGraphException(f + " is not jar as expected");
            }
            JarFile jf = null;
            try {
                jf = new JarFile(f);
                Enumeration<JarEntry> enm = jf.entries();
                while (enm.hasMoreElements()) {
                    JarEntry entry = enm.nextElement();
                    String entryName = entry.getName().toLowerCase();
                    boolean isTG = entryName.equalsIgnoreCase("graph.tg");
                    if (!isTG) continue;
                    try {
                        Binding binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
                        long size = entry.getSize();
                        InputStream is = jf.getInputStream(entry);
                        TransferableGraph1 transferableGraph1 = (TransferableGraph1)Files.readFile((InputStream)is, (long)size, (Binding)binding);
                        return transferableGraph1;
                    }
                    catch (IOException e) {
                        throw new TransferableGraphException((Throwable)e);
                        throw new TransferableGraphException(".tg file was not found in " + key);
                    }
                }
            }
            catch (IOException e) {
                throw new TransferableGraphException((Throwable)e);
            }
            finally {
                try {
                    if (jf != null) {
                        jf.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        try {
            int size = Integer.valueOf((String)desc.getProperties().get("download.size"));
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
            repo.getArtifact(desc, (OutputStream)bos, null);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            JarInputStream jis = new JarInputStream(bis);
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry == null) {
                    throw new TransferableGraphException(".tg file was not found in " + key);
                }
                String entryName = entry.getName().toLowerCase();
                boolean isTG = entryName.equalsIgnoreCase("graph.tg");
                if (isTG) {
                    Binding binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
                    return (TransferableGraph1)Files.readFile((InputStream)jis, (Binding)binding);
                }
                entry = jis.getNextJarEntry();
            }
        }
        catch (IOException e) {
            throw new TransferableGraphException((Throwable)e);
        }
    }

    public static String getDescription(IInstallableUnit iu) {
        return iu.getProperty("org.eclipse.equinox.p2.description");
    }

    public static String getName(IInstallableUnit iu) {
        return iu.getProperty("org.eclipse.equinox.p2.name");
    }

    public static IInstallableUnit createBundleIU(IArtifactKey artifactKey, File bundleFile) {
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleFile);
        if (bundleDescription == null) {
            return null;
        }
        PublisherInfo info = new PublisherInfo();
        Version version = Version.create((String)bundleDescription.getVersion().toString());
        AdviceFileAdvice advice = new AdviceFileAdvice(bundleDescription.getSymbolicName(), version, (IPath)new Path(bundleFile.getAbsolutePath()), AdviceFileAdvice.BUNDLE_ADVICE_FILE);
        if (advice.containsAdvice()) {
            info.addAdvice((IPublisherAdvice)advice);
        }
        String shape = bundleFile.isDirectory() ? "dir" : "jar";
        info.addAdvice((IPublisherAdvice)new BundleShapeAdvice(bundleDescription.getSymbolicName(), version, shape));
        return BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)artifactKey, (IPublisherInfo)info);
    }

    public static IFileArtifactRepository getDownloadCacheRepo(IProvisioningAgent agent) throws ProvisionException {
        return Util.getDownloadCacheRepo((IProvisioningAgent)agent);
    }

    public static Comparator<IInstallableUnit> getIUComparator() {
        return new Comparator<IInstallableUnit>(){

            @Override
            public int compare(IInstallableUnit o1, IInstallableUnit o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
    }

    public static TreeSet<IInstallableUnit> getSorted(Iterator<IInstallableUnit> iter) {
        TreeSet<IInstallableUnit> result = new TreeSet<IInstallableUnit>(ProvisioningUtil.getIUComparator());
        while (iter.hasNext()) {
            IInstallableUnit iu = iter.next();
            result.add(iu);
        }
        return result;
    }

    public static TreeSet<IInstallableUnit> getSorted(IQueryResult<IInstallableUnit> result) {
        return ProvisioningUtil.getSorted(result.iterator());
    }
}

