/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.osgi.framework.Bundle;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.db.Resource;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.request.Write;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.project.internal.Activator;
import org.simantics.project.management.BundlePool;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.ManagedDatabase;
import org.simantics.project.management.P2Util;
import org.simantics.project.management.ProvisioningUtil;
import org.simantics.project.management.SPMUtil;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.WorkspaceUtil;
import org.simantics.project.management.install.DefaultInstallAdvisor;
import org.simantics.project.management.install.InstallerUtil;
import org.simantics.utils.FileUtils;

public class ManagedWorkspace {
    public final File location;
    public final IProvisioningAgent provisioningAgent;
    public final File databaseLocation;
    public final File propertyFile;
    public final boolean standalone;
    public final String name;
    public final String projectUri;
    ILog log;

    public static ManagedWorkspace createLocal(final String name, File workspaceLocation, IProgressMonitor m, boolean standalone) throws Exception {
        m.beginTask("Creating a new local project", 100);
        m.setTaskName("Creating a directory");
        FileUtils.deleteDir((File)workspaceLocation);
        if (!workspaceLocation.mkdirs()) {
            throw new ProvisionException("Failed to create " + workspaceLocation);
        }
        m.worked(5);
        ServerEx server = null;
        Session session = null;
        try {
            m.setTaskName("Creating a database");
            File databaseLocation = new File(workspaceLocation, "db");
            ManagedDatabase db = ManagedDatabase.createLocal(databaseLocation);
            m.worked(20);
            m.setTaskName("Starting the database server");
            server = db.createServerHandle();
            server.start();
            session = server.createSession(ServerManager.DEFAULT);
            m.worked(5);
            m.setTaskName("Creating a new project in the database");
            final MutableString projectUri = new MutableString();
            WriteRequest req = new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    Transaction.setGraph((Object)g);
                    try {
                        DatabaseManagement mgnt = new DatabaseManagement();
                        ArrayList<String> features = new ArrayList<String>();
                        Resource project = mgnt.createProject(name, features);
                        projectUri.setValue(g.getURI(project));
                    }
                    finally {
                        Transaction.setGraph(null);
                    }
                }
            };
            session.syncRequest((Write)req);
            m.worked(5);
            m.setTaskName("Closing the database server");
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
            session = null;
            server.stop();
            server = null;
            m.worked(5);
            m.setTaskName("Stuff");
            Properties props = new Properties();
            props.setProperty("name", name);
            props.setProperty("project_uri", projectUri.getValue());
            props.setProperty("standalone", Boolean.valueOf(standalone).toString());
            File propertyFile = new File(workspaceLocation, "simantics.cfg");
            WorkspaceUtil.writeProperties(propertyFile, props);
            m.worked(5);
            ManagedWorkspace ws = new ManagedWorkspace(workspaceLocation);
            ws.provision(m, "org.simantics.workbench.product");
            FileOutputStream fos = new FileOutputStream(new File(workspaceLocation, "SimanticsWorkbench.ini"), true);
            fos.write("-Dosgi.instance.area\r\n.\r\n".getBytes());
            fos.close();
            m.done();
            return ws;
        }
        catch (Exception e) {
            if (session != null) {
                try {
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                }
                catch (ServiceNotFoundException e2) {
                    throw new ProvisionException("Failed to create database: " + e.getMessage(), (Throwable)e2);
                }
                catch (DatabaseException e2) {
                    throw new ProvisionException("Failed to create database: " + e.getMessage(), (Throwable)e2);
                }
            }
            if (server != null) {
                try {
                    server.stop();
                }
                catch (DatabaseException e2) {
                    throw new ProvisionException("Failed to create database: " + e.getMessage(), (Throwable)e2);
                }
            }
            FileUtils.deleteDir((File)workspaceLocation);
            m.done();
            throw e;
        }
    }

    public static ManagedWorkspace openLocal(File location) throws ProvisionException {
        return new ManagedWorkspace(location);
    }

    public static ManagedWorkspace checkoutRemoteProject(File workspaceLocation, ServerAddress address, String projectUri, IProgressMonitor m, boolean standalone) throws Exception {
        try {
            m.setTaskName("Creating a workspace");
            FileUtils.deleteDir((File)workspaceLocation);
            if (!workspaceLocation.mkdirs()) {
                throw new ProvisionException("Failed to create " + workspaceLocation);
            }
            File databaseLocation = new File(workspaceLocation, "db");
            ManagedDatabase db = ManagedDatabase.checkoutRemote(databaseLocation, address, m);
            m.setTaskName("Starting the database server");
            m.setTaskName("Reading the project");
            ServerEx server = db.createServerHandle();
            String projectName = null;
            server.start();
            try {
                Session session = server.createSession(ServerManager.DEFAULT);
                try {
                    projectName = (String)session.syncRequest(Queries.name((String)projectUri));
                }
                finally {
                    ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                }
            }
            finally {
                server.stop();
            }
            m.worked(5);
            Properties props = new Properties();
            props.setProperty("project_name", projectName);
            props.setProperty("project_uri", projectUri);
            props.setProperty("standalone", Boolean.valueOf(standalone).toString());
            File propertyFile = new File(workspaceLocation, "simantics.cfg");
            WorkspaceUtil.writeProperties(propertyFile, props);
            ManagedWorkspace ws = new ManagedWorkspace(workspaceLocation);
            m.worked(5);
            m.setTaskName("Installing plugins");
            ws.provision(m, "org.simantics.workbench.product");
            m.worked(25);
            m.setTaskName("Finalizing");
            FileOutputStream fos = new FileOutputStream(new File(workspaceLocation, "SimanticsWorkbench.ini"), true);
            fos.write("-Dosgi.instance.area\r\n.\r\n".getBytes());
            fos.close();
            return new ManagedWorkspace(workspaceLocation);
        }
        catch (Exception e) {
            FileUtils.deleteDir((File)workspaceLocation);
            m.done();
            throw e;
        }
    }

    ManagedWorkspace(File location) throws ProvisionException {
        this.location = location;
        this.propertyFile = new File(location, "simantics.cfg");
        this.databaseLocation = new File(location, "db");
        File agentLocation = new File(location, "P2");
        this.provisioningAgent = P2Util.createAgent((IPath)new Path(agentLocation.getAbsolutePath()));
        Properties properties = this.readProperties();
        this.name = properties.getProperty("project_name");
        this.projectUri = properties.getProperty("project_uri");
        this.standalone = Boolean.getBoolean(properties.getProperty("standalone"));
        this.log = Platform.getLog((Bundle)Activator.getDefault().getBundle());
    }

    public File getLocation() {
        return this.location;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    public void writeProperties(Properties props) {
        OutputStreamWriter fw = null;
        try {
            try {
                fw = new FileWriter(this.propertyFile, false);
                props.store(fw, "Project configuration");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Properties readProperties() {
        FileReader fr = null;
        try {
            fr = new FileReader(this.propertyFile);
            Properties props = new Properties();
            props.load(fr);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getProjectURI() {
        return this.projectUri;
    }

    public IProfile getActiveProfile() {
        IProfileRegistry registry = (IProfileRegistry)this.provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        String profileId = (String)this.provisioningAgent.getService("org.eclipse.equinox.p2.installer.profile.id");
        IProfile result = null;
        IProfile[] iProfileArray = registry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile profile = iProfileArray[n2];
            if (result == null) {
                result = profile;
            } else if (profile.getTimestamp() > result.getTimestamp()) {
                result = profile;
            }
            System.out.println("Profile: " + profile.getTimestamp() + " : " + profile.getProfileId());
            ++n2;
        }
        return result;
    }

    public void getProvisionedGraphBundles(Collection<GraphBundle> result) throws ProvisionException, TransferableGraphException {
        IProfile profile = this.getActiveProfile();
        URI repoUri1 = new File(this.location, "p2/org.eclipse.equinox.p2.touchpoint.eclipse").toURI();
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (artifactManager == null) {
            throw new ProvisionException("Could not load artifact repository manager.");
        }
        IArtifactRepository repo1 = null;
        try {
            repo1 = artifactManager.loadRepository(repoUri1, null);
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        URI repoUri2 = SPMUtil.getRepositoryLocation();
        IArtifactRepository repo2 = null;
        repo2 = artifactManager.loadRepository(repoUri2, null);
        IInstallableUnit[] iInstallableUnitArray = (IInstallableUnit[])profile.query(QueryUtil.createIUAnyQuery(), null).toArray(IInstallableUnit.class);
        int n = iInstallableUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            for (IArtifactKey key : iu.getArtifacts()) {
                GraphBundle bundle;
                if (repo1 != null && repo1.contains(key)) {
                    try {
                        if (!ProvisioningUtil.isGraphArtifact(repo1, key)) {
                        }
                    }
                    catch (IOException e) {}
                    continue;
                    bundle = ProvisioningUtil.getGraphBundle(repo1, key, iu);
                    result.add(bundle);
                    continue;
                }
                if (repo2 == null || !repo2.contains(key)) continue;
                try {
                    if (!ProvisioningUtil.isGraphArtifact(repo2, key)) {
                    }
                }
                catch (IOException e) {}
                continue;
                bundle = ProvisioningUtil.getGraphBundle(repo2, key, iu);
                result.add(bundle);
            }
            ++n2;
        }
    }

    public void provision(IProgressMonitor monitor, String ... features) throws Exception {
        monitor.setTaskName("Installing Simantics Workbench");
        IPath repositoryLocation = Platform.getLocation().append("repository");
        URI repositoryUri = repositoryLocation.toFile().toURI();
        InstallDescription desc = new InstallDescription();
        desc.setArtifactRepositories(new URI[]{repositoryUri});
        desc.setMetadataRepositories(new URI[]{repositoryUri});
        desc.setInstallLocation((IPath)new Path(this.location.getPath()));
        desc.setLauncherName("SimanticsWorkbench");
        desc.setProductName("Simantics SDK");
        if (!this.standalone) {
            desc.setBundleLocation(repositoryLocation);
        }
        desc.setAutoStart(true);
        BundlePool pool = BundlePool.getDefault();
        ArrayList<IInstallableUnit> roots = new ArrayList<IInstallableUnit>();
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)feature));
            IQueryResult result = pool.getMetadataRepository().query(query, monitor);
            IInstallableUnit[] iInstallableUnitArray = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
            int n3 = iInstallableUnitArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IInstallableUnit iu = iInstallableUnitArray[n4];
                roots.add(iu);
                ++n4;
            }
            ++n2;
        }
        desc.setRoots((IVersionedId[])roots.toArray(new IInstallableUnit[0]));
        DefaultInstallAdvisor advisor = new DefaultInstallAdvisor();
        advisor.setMonitor(monitor);
        advisor.start();
        IStatus status = InstallerUtil.install(advisor, desc, monitor);
        if (!status.isOK()) {
            if (status.getException() == null) {
                throw new Exception(status.getMessage());
            }
            if (status.getException() instanceof Exception) {
                throw (Exception)status.getException();
            }
            throw new Exception(status.getException());
        }
        FileOutputStream fos = new FileOutputStream(new File(this.location, "SimanticsWorkbench.ini"), true);
        fos.write("-Dosgi.instance.area\r\n.\r\n".getBytes());
        fos.close();
    }
}

