/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.osgi.framework.Bundle;
import org.simantics.db.Resource;
import org.simantics.db.ServerAddress;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.graph.db.GraphDependencyAnalyzer;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.project.internal.Activator;
import org.simantics.project.management.BundlePool;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.project.management.GraphBundleRef;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.utils.datastructures.Pair;

public class ManagedDatabase {
    File databaseLocation;
    ServerManager serverManager;
    ILog log;
    String username = "";
    String password = "";
    DatabaseManagement mgmt;

    public static ManagedDatabase createLocal(File databaseLocation) throws DatabaseException, ProvisionException, TransferableGraphException {
        ServerManager serverManager = ServerManagerFactory.getServerManager();
        GraphBundleEx layer0 = BundlePool.getDefault().getLayer0();
        serverManager.createDatabase(databaseLocation, layer0);
        return new ManagedDatabase(databaseLocation);
    }

    public static ManagedDatabase createLocal(File databaseLocation, GraphBundle layer0) throws DatabaseException {
        ServerManager serverManager = ServerManagerFactory.getServerManager();
        serverManager.createDatabase(databaseLocation, layer0);
        return new ManagedDatabase(databaseLocation);
    }

    public static ManagedDatabase checkoutRemote(File databaseLocation, ServerAddress server, IProgressMonitor monitor) throws DatabaseException {
        ServerManager serverManager = ServerManagerFactory.getServerManager();
        serverManager.createCheckout(server, databaseLocation);
        return new ManagedDatabase(databaseLocation);
    }

    public static ManagedDatabase open(File databaseLocation) {
        return new ManagedDatabase(databaseLocation);
    }

    ManagedDatabase(File databaseLocation) {
        this.databaseLocation = databaseLocation;
        this.log = Platform.getLog((Bundle)Activator.getDefault().getBundle());
        this.serverManager = ServerManagerFactory.getServerManager();
        this.mgmt = new DatabaseManagement();
        try {
            this.serverManager = ServerManagerFactory.createOSGI();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Properties readProperties() throws IOException {
        Properties properties = new Properties();
        File file = new File(this.databaseLocation, "procore.config.procore");
        FileReader fr = new FileReader(file);
        try {
            properties.load(fr);
        }
        finally {
            fr.close();
        }
        return properties;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServerEx createServerHandle() throws DatabaseException {
        return this.serverManager.getServer(this.databaseLocation);
    }

    public Set<String> getInstalledProjectURIs() throws DatabaseException {
        ServerEx server = this.createServerHandle();
        server.start();
        try {
            Set set;
            Session session = server.createSession(ServerManager.DEFAULT);
            try {
                set = (Set)session.syncRequest(this.mgmt.ProjectURIQuery);
            }
            catch (Throwable throwable) {
                ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                throw throwable;
            }
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
            return set;
        }
        finally {
            server.stop();
        }
    }

    public Set<GraphBundleRef> getInstalledGraphBundleReferences() throws DatabaseException {
        ServerEx server = this.createServerHandle();
        server.start();
        try {
            Set set;
            Session session = server.createSession(ServerManager.DEFAULT);
            try {
                set = (Set)session.syncRequest(this.mgmt.GraphBundleRefQuery);
            }
            catch (Throwable throwable) {
                ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                throw throwable;
            }
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
            return set;
        }
        finally {
            server.stop();
        }
    }

    public Set<GraphBundle> getInstalledGraphBundles() throws DatabaseException {
        ServerEx server = this.createServerHandle();
        server.start();
        try {
            Set set;
            Session session = server.createSession(ServerManager.DEFAULT);
            try {
                set = (Set)session.syncRequest(this.mgmt.GraphBundleQuery);
            }
            catch (Throwable throwable) {
                ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
                throw throwable;
            }
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
            return set;
        }
        finally {
            server.stop();
        }
    }

    public void installGraphs(Collection<GraphBundle> graphs, final IProgressMonitor monitor) throws DatabaseException {
        if (graphs.isEmpty()) {
            return;
        }
        monitor.setTaskName("Calculating Transferable Graph dependencies");
        final GraphDependencyAnalyzer analyzer = new GraphDependencyAnalyzer();
        for (GraphBundle tg : graphs) {
            analyzer.addGraph((Comparable)tg, tg.getGraph());
        }
        if (!analyzer.analyzeDependency()) {
            Collection problems = analyzer.getConflicts();
            StringBuilder sb = new StringBuilder();
            for (Pair problem : problems) {
                sb.append("Conflict with " + problem.first + " and " + problem.second + ".\n");
            }
            throw new DatabaseException(sb.toString());
        }
        monitor.setTaskName("Starting database process");
        ServerEx server = this.createServerHandle();
        server.start();
        try {
            monitor.setTaskName("Opening session");
            Session session = server.createSession(ServerManager.DEFAULT);
            monitor.setTaskName("Verifying external dependencies");
            if (!((Boolean)session.syncRequest(analyzer.queryExternalDependenciesSatisfied)).booleanValue()) {
                ArrayList unsatisfiedDependencies = analyzer.getUnsatisfiedDependencies();
                StringBuilder sb = new StringBuilder();
                for (GraphDependencyAnalyzer.IdentityNode dep : unsatisfiedDependencies) {
                    sb.append("Unsatisfied Dependency " + dep + ". Required by\n");
                    for (GraphDependencyAnalyzer.IU iu : GraphDependencyAnalyzer.toCollection((GraphDependencyAnalyzer.IUList)dep.getRequires())) {
                        sb.append("    " + ((GraphBundle)iu.getId()).getId() + "\n");
                    }
                }
                throw new DatabaseException(sb.toString());
            }
            session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ImportAdvisor advisor = new ImportAdvisor();
                    Transaction.setGraph((Object)graph);
                    DatabaseManagement mgmt = new DatabaseManagement();
                    try {
                        try {
                            for (GraphBundle tg : analyzer.getSortedGraphs()) {
                                GraphBundle oldTG;
                                Resource oldTGResouce = mgmt.getGraphBundleResource(tg.getId(), tg.getMajor());
                                GraphBundle graphBundle = oldTG = oldTGResouce == null ? null : mgmt.getGraphBundle(oldTGResouce);
                                if (oldTG == null) {
                                    monitor.setTaskName("Installing " + tg.getName() + " (" + tg.getVersionedId() + ")");
                                    ManagedDatabase.this.log.log((IStatus)new Status(1, "org.simantics.project", "Installing " + tg.getVersionedId() + " - " + tg.getName()));
                                    long[] resourceArray = TransferableGraphs.importGraph((WriteGraph)graph, (Object)tg.getGraph(), (IImportAdvisor)advisor);
                                    tg.setResourceArray(resourceArray);
                                    mgmt.setGraphBundleEntry(tg);
                                    continue;
                                }
                                if (oldTG.getVersionedId().equals(tg.getVersionedId())) {
                                    ManagedDatabase.this.log.log((IStatus)new Status(1, "org.simantics.project", "Omiting " + tg.getVersionedId() + " - Already Installed"));
                                    continue;
                                }
                                monitor.setTaskName("Updating " + tg.getName() + " " + oldTG.getVersionedId() + " to " + tg.getVersionedId());
                                ManagedDatabase.this.log.log((IStatus)new Status(1, "org.simantics.project", "Converting " + oldTG.getVersionedId() + " to " + tg.getVersionedId()));
                                TransferableGraphDelta1 delta = new Diff(oldTG.getGraph(), tg.getGraph()).diff();
                                long[] oldResources = oldTG.getResourceArray();
                                long[] resourceArray = TransferableGraphs.applyDelta((WriteGraph)graph, (long[])oldResources, (TransferableGraphDelta1)delta);
                                tg.setResourceArray(resourceArray);
                                mgmt.setGraphBundleEntry(tg);
                            }
                        }
                        catch (TransferableGraphException e) {
                            throw new DatabaseException((Throwable)e);
                        }
                    }
                    finally {
                        Transaction.setGraph(null);
                    }
                }
            });
            ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
        }
        finally {
            server.stop();
        }
    }
}

