/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.features;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.scl.reflection.OntologyVersions;

public class DependencyValidationFeature
extends AbstractProjectFeature
implements IExecutableExtension {
    private String virtualGraphId;
    private String[] uris = new String[0];

    public DependencyValidationFeature() {
    }

    public DependencyValidationFeature(String virtualGraphId, String[] uris) {
        this.virtualGraphId = virtualGraphId;
        this.uris = uris;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String[] uris;
        if (data instanceof String && (uris = ((String)data).split(",")).length > 0) {
            int i = 0;
            while (i < uris.length) {
                uris[i] = OntologyVersions.getInstance().currentVersion(uris[i]);
                ++i;
            }
            String[] stringArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    new URI(uri);
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, config.getContributor().getName(), "extension configuration element executable extension attribute '" + propertyName + "' argument contains invalid URIs. See cause for details.", (Throwable)e));
                }
                ++n2;
            }
            this.uris = uris;
        }
    }

    @Override
    public void configure() throws ProjectException {
        try {
            Session s = this.getSession();
            VirtualGraph vg = null;
            if (this.virtualGraphId != null) {
                VirtualGraphSupport support = (VirtualGraphSupport)s.getService(VirtualGraphSupport.class);
                vg = support.getWorkspacePersistent(this.virtualGraphId);
            }
            this.getSession().syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DependencyValidationFeature.this.configure(graph);
                    graph.addMetadata((Metadata)((CommentMetadata)graph.getMetadata(CommentMetadata.class)).add("Configured by Dependency Validation Feature."));
                }
            });
        }
        catch (DatabaseException e) {
            throw new ProjectException(e.getMessage(), e);
        }
    }

    protected void configure(WriteGraph graph) throws DatabaseException {
        ArrayList<String> nss = new ArrayList<String>();
        ArrayList<String> notFound = new ArrayList<String>();
        Resource project = (Resource)this.getProject().get();
        String projectName = NameUtils.getSafeName((ReadGraph)graph, (Resource)project);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> resourcesToLinkToProject = new ArrayList<Resource>();
        String[] stringArray = this.uris;
        int n = this.uris.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String uri = stringArray[n2];
                Resource namespaceRequirement = null;
                try {
                    namespaceRequirement = graph.getResource(uri);
                    resourcesToLinkToProject.add(namespaceRequirement);
                }
                catch (ResourceNotFoundException e) {
                    notFound.add(uri);
                    break block9;
                }
                for (Resource nsp : graph.getObjects(namespaceRequirement, PROJ.RequiresNamespace)) {
                    String ns = (String)graph.getValue(nsp);
                    nss.add(ns);
                }
                for (String ns : nss) {
                    try {
                        graph.getResource(ns);
                    }
                    catch (ResourceNotFoundException e) {
                        notFound.add(ns);
                    }
                }
            }
            ++n2;
        }
        if (!notFound.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to locate the following namespaces required by project '");
            sb.append(projectName);
            sb.append("':\n");
            for (String nf : notFound) {
                sb.append("\t");
                sb.append(nf);
                sb.append("\n");
            }
            throw new AssumptionException(sb.toString());
        }
        this.linkTo(graph, project, resourcesToLinkToProject);
    }

    protected void linkTo(WriteGraph graph, Resource target, ArrayList<Resource> resourcesToLink) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource resource : resourcesToLink) {
            if (graph.hasStatement(target, L0.IsLinkedTo, resource)) continue;
            graph.claim(target, L0.IsLinkedTo, resource);
        }
    }

    @Override
    public void deconfigure() throws ProjectException {
    }
}

