/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.GroupFilter;
import org.simantics.project.GroupFilters;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.features.registry.IProjectFeatureExtension;
import org.simantics.project.features.registry.IProjectFeatureRegistry;
import org.simantics.project.features.registry.InjectedDependency;
import org.simantics.project.features.registry.ProjectFeatureReference;
import org.simantics.project.internal.Activator;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.utils.datastructures.MapSet;

public class ProjectFeatures {
    static String ID_PATTERN_STRING = "[a-zA-Z_0-9]+(?:\\.[a-zA-Z_0-9]+)*";
    static String VERSION_PATTERN_STRING = ".*";
    static Pattern POSSIBLY_VERSIONED_ID_PATTERN = Pattern.compile("(" + ID_PATTERN_STRING + ")(?:/(" + VERSION_PATTERN_STRING + "))?");

    public static IProjectFeatureRegistry getRegistry() {
        return Activator.getDefault().getProjectFeatureRegistry();
    }

    public static IProjectFeatureExtension[] getAllProjectFeatures() {
        return ProjectFeatures.getRegistry().getExtensions();
    }

    public static Collection<IProjectFeatureExtension> getPublishedProjectFeatures() {
        IProjectFeatureExtension[] extensions = ProjectFeatures.getAllProjectFeatures();
        ArrayList<IProjectFeatureExtension> result = new ArrayList<IProjectFeatureExtension>();
        IProjectFeatureExtension[] iProjectFeatureExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFeatureExtension ext = iProjectFeatureExtensionArray[n2];
            if (ext.isPublished()) {
                result.add(ext);
            }
            ++n2;
        }
        return result;
    }

    public static Set<GroupReference> getInstallGroupsOfPublishedFeatures() {
        return ProjectFeatures.getInstallGroups(ProjectFeatures.getPublishedProjectFeatures());
    }

    public static Set<GroupReference> getInstallGroups(Collection<IProjectFeatureExtension> extensions) {
        TreeSet<GroupReference> result = new TreeSet<GroupReference>();
        for (IProjectFeatureExtension ext : extensions) {
            for (GroupReference grp : ext.installGroups()) {
                result.add(grp);
            }
        }
        return result;
    }

    public static Collection<IProjectFeatureExtension> filterPublishedFeatures(GroupFilter filter) {
        return ProjectFeatures.filterExtensions(ProjectFeatures.getPublishedProjectFeatures(), filter);
    }

    private static Set<IProjectFeatureExtension> filterExtensions(Collection<IProjectFeatureExtension> extensions, GroupFilter filter) {
        HashSet<IProjectFeatureExtension> included = new HashSet<IProjectFeatureExtension>();
        for (IProjectFeatureExtension ext : extensions) {
            if (!ProjectFeatures.acceptExtension(ext, filter)) continue;
            included.add(ext);
        }
        return included;
    }

    private static boolean acceptExtension(IProjectFeatureExtension extension, GroupFilter filter) {
        for (GroupReference grp : extension.installGroups()) {
            if (!filter.accept(grp)) continue;
            return true;
        }
        return false;
    }

    public static Collection<IProjectFeatureExtension> getTopologicallySortedFeatures(GroupFilter filter) throws DatabaseException, ProjectException {
        return new FeatureWalker().getSortedFeatures(filter);
    }

    public static Collection<IProjectFeatureExtension> getTopologicallySortedFeatures(ReadGraph g, Resource project) throws DatabaseException, ProjectException {
        return new FeatureWalker().getSortedFeatures(g, project);
    }

    private static Set<GroupReference> loadFeatureReferences(ReadGraph graph, Resource project) throws DatabaseException {
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        HashSet<GroupReference> features = new HashSet<GroupReference>();
        for (Resource fs : graph.getObjects(project, PROJ.HasFeature)) {
            String refStr = (String)graph.getRelatedValue(fs, PROJ.HasGroupId, (Binding)Bindings.STRING);
            try {
                GroupReference ref = ProjectFeatures.parseFeatureReference(refStr);
                features.add(ref);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        features.add(GroupReference.OMNIPRESENT);
        return features;
    }

    private static Map<String, IProjectFeatureExtension> createIdMap(IProjectFeatureExtension[] extensions) {
        HashMap<String, IProjectFeatureExtension> byId = new HashMap<String, IProjectFeatureExtension>();
        IProjectFeatureExtension[] iProjectFeatureExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFeatureExtension ext = iProjectFeatureExtensionArray[n2];
            IProjectFeatureExtension e = byId.put(ext.getId(), ext);
            if (e != null) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.project", "Multiple org.simantics.project.feature extensions defined with id '" + ext.getId() + "'.\nprevious: " + e + "\nnew: " + ext));
            }
            ++n2;
        }
        return byId;
    }

    private static GroupReference parseFeatureReference(String reference) {
        Matcher m = POSSIBLY_VERSIONED_ID_PATTERN.matcher(reference);
        if (m.matches()) {
            return new GroupReference(m.group(1), m.group(2));
        }
        throw new IllegalArgumentException("could not parse feature reference " + reference);
    }

    private static class FeatureWalker {
        private Map<String, IProjectFeatureExtension> byId;
        private final MapSet<IProjectFeatureExtension, IProjectFeatureExtension> required = new MapSet.Hash();

        private FeatureWalker() {
        }

        private IProjectFeatureExtension getExtension(ProjectFeatureReference ref) {
            return this.byId.get(ref.id);
        }

        public Collection<IProjectFeatureExtension> getSortedFeatures(ReadGraph g, Resource project) throws DatabaseException, ProjectException {
            Set projectDefinedFeatures = ProjectFeatures.loadFeatureReferences(g, project);
            return this.getSortedFeatures(GroupFilters.includesVersion(projectDefinedFeatures));
        }

        public Collection<IProjectFeatureExtension> getSortedFeatures(GroupFilter filter) throws DatabaseException, ProjectException {
            IProjectFeatureExtension[] allExtensions = ProjectFeatures.getAllProjectFeatures();
            this.byId = ProjectFeatures.createIdMap(allExtensions);
            Set included = ProjectFeatures.filterExtensions(Arrays.asList(allExtensions), filter);
            Collection<IProjectFeatureExtension> required = this.requiredExtensions(allExtensions, included);
            return this.sortTopologically(required);
        }

        private boolean deepRequires(Set<IProjectFeatureExtension> visited, IProjectFeatureExtension e1, IProjectFeatureExtension e2) {
            if (visited.add(e1)) {
                Set req = this.required.getValues((Object)e1);
                if (req == null) {
                    return false;
                }
                if (req.contains(e2)) {
                    return true;
                }
                for (IProjectFeatureExtension r : req) {
                    if (!this.deepRequires(visited, r, e2)) continue;
                    return true;
                }
            }
            return false;
        }

        private Collection<IProjectFeatureExtension> sortTopologically(Collection<IProjectFeatureExtension> toSort) {
            ArrayList<IProjectFeatureExtension> sorted = new ArrayList<IProjectFeatureExtension>(toSort);
            Collections.sort(sorted, new Comparator<IProjectFeatureExtension>(){
                Set<IProjectFeatureExtension> visited = new HashSet<IProjectFeatureExtension>();

                @Override
                public int compare(IProjectFeatureExtension e1, IProjectFeatureExtension e2) {
                    this.visited.clear();
                    if (FeatureWalker.this.deepRequires(this.visited, e1, e2)) {
                        return 1;
                    }
                    this.visited.clear();
                    if (FeatureWalker.this.deepRequires(this.visited, e2, e1)) {
                        return -1;
                    }
                    return 0;
                }
            });
            return sorted;
        }

        private Collection<IProjectFeatureExtension> requiredExtensions(IProjectFeatureExtension[] allExtensions, Collection<IProjectFeatureExtension> includedExtensions) throws ProjectException {
            ArrayList<IProjectFeatureExtension> result = new ArrayList<IProjectFeatureExtension>();
            HashSet<IProjectFeatureExtension> visited = new HashSet<IProjectFeatureExtension>();
            for (IProjectFeatureExtension ext : includedExtensions) {
                this.walkRequired(result, visited, ext);
            }
            HashSet<String> includedProjectFeatureIds = new HashSet<String>();
            for (IProjectFeatureExtension ext : result) {
                includedProjectFeatureIds.add(ext.getId());
            }
            boolean changed = false;
            HashSet<IProjectFeatureExtension> injectionsProcessedFor = new HashSet<IProjectFeatureExtension>();
            do {
                changed = false;
                IProjectFeatureExtension[] iProjectFeatureExtensionArray = allExtensions;
                int n = allExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFeatureExtension ext = iProjectFeatureExtensionArray[n2];
                    if (!injectionsProcessedFor.contains(ext)) {
                        for (InjectedDependency injection : ext.injections()) {
                            if (!includedProjectFeatureIds.contains(injection.to.id)) continue;
                            injectionsProcessedFor.add(ext);
                            IProjectFeatureExtension injectionTargetExt = this.byId.get(injection.to.id);
                            if (injectionTargetExt == null) continue;
                            changed = true;
                            includedProjectFeatureIds.add(ext.getId());
                            result.add(ext);
                            this.required.add((Object)injectionTargetExt, (Object)ext);
                        }
                    }
                    ++n2;
                }
            } while (changed);
            return result;
        }

        private void walkRequired(Collection<IProjectFeatureExtension> result, Set<IProjectFeatureExtension> visited, IProjectFeatureExtension extension) throws ProjectException {
            if (visited.add(extension)) {
                result.add(extension);
                for (ProjectFeatureReference ref : extension.requires()) {
                    IProjectFeatureExtension reqExt = this.getExtension(ref);
                    if (reqExt != null) {
                        this.required.add((Object)extension, (Object)reqExt);
                        this.walkRequired(result, visited, reqExt);
                        continue;
                    }
                    if (ref.optional) continue;
                    throw new ProjectException("Missing org.simantics.project.feature extension with id '" + ref.id + "' required by feature '" + extension.getId() + "'");
                }
            }
        }
    }
}

