/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.spm;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.utils.FileUtils;

public class ServerManagerExample {
    public static void main(String[] args) throws Exception {
        Binding binding = Bindings.getBinding(TransferableGraph1.class);
        InputStream is = ServerManagerExample.class.getResourceAsStream("Layer0.tg");
        TransferableGraph1 layer0 = (TransferableGraph1)Files.readFile((InputStream)is, (Binding)binding);
        is.close();
        ServerManager manager = ServerManagerFactory.createPOJO();
        File databaseDir = FileUtils.createTmpDir();
        GraphBundle entry = new GraphBundle("Layer0", layer0, "org.simantics.layer0_1.0.0.0");
        manager.createDatabase(databaseDir, entry);
        ServerEx server1 = manager.getServer(databaseDir);
        server1.start();
        Session session = server1.createSession(ServerManager.DEFAULT);
        session.syncRequest((Read)new TestRequest());
        ((LifecycleSupport)session.getService(LifecycleSupport.class)).close();
        server1.stop();
        manager.close();
        FileUtils.deleteDir((File)databaseDir);
    }

    static class TestRequest
    extends ReadRequest {
        TestRequest() {
        }

        public void run(ReadGraph g) throws DatabaseException {
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            Collection resources = g.getObjects(g.getRootLibrary(), b.ConsistsOf);
            for (Resource r : resources) {
                String name = (String)g.getPossibleRelatedValue(r, b.HasName);
                System.out.println(name);
            }
        }
    }
}

