/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URI;
import org.eclipse.core.internal.resources.PreferenceInitializer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.simantics.db.ServerEx;
import org.simantics.project.management.BundlePool;
import org.simantics.project.management.ManagedDatabase;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.utils.FileUtils;

public class TestDatabaseManagement {
    ServerManager manager;
    ServerEx server;
    BundlePool bundlePool;
    File databaseLocation;

    @Before
    public void init() throws Exception {
        PreferenceInitializer PreferenceInitializer2 = new PreferenceInitializer();
        PreferenceInitializer2.initializeDefaultPreferences();
        Bundle bundle = Platform.getBundle((String)"org.simantics.project");
        System.out.println(bundle);
        bundle = Platform.getBundle((String)"org.eclipse.osgi");
        System.out.println(bundle);
        this.manager = ServerManagerFactory.getServerManager();
        File bundlePoolLocation = FileUtils.getOrCreateTemporaryDirectory((boolean)false, (String[])new String[]{"bundle_pool"});
        this.bundlePool = BundlePool.createAt(bundlePoolLocation);
        URI uri = new URI("http://www.simantics.org/update/trunk");
        System.out.println("Synchronizing BundlePool(" + bundlePoolLocation + ") with " + uri);
        this.bundlePool.download((IProgressMonitor)new NullProgressMonitor(), new URI[]{uri});
        this.databaseLocation = FileUtils.createTmpDir();
        System.out.println("Creating database at " + this.databaseLocation);
        ManagedDatabase.createLocal(this.databaseLocation);
        this.server = this.manager.getServer(this.databaseLocation);
        this.server.start();
    }

    @After
    public void uninit() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.manager != null) {
            this.manager.close();
        }
        if (this.databaseLocation != null) {
            FileUtils.deleteDir((File)this.databaseLocation);
        }
    }

    @Test
    public void createDatabase() throws Exception {
    }
}

