/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.expressions.EnvironmentDescription;
import org.simantics.structural.flattening.synchronization.ConnectionBuilder;
import org.simantics.structural.flattening.types.ComponentTypeContext;
import org.simantics.structural.stubs.StructuralResource2;

public class ContextSupport<Connection> {
    THashMap<Resource, Connection> cache = new THashMap();
    ConnectionBuilder<Connection> builder;
    ComponentTypeContext<Connection> context;
    EnvironmentDescription<ComponentTypeContext<Connection>> environment;

    public ContextSupport(ConnectionBuilder<Connection> builder, ComponentTypeContext<Connection> context, EnvironmentDescription<ComponentTypeContext<Connection>> environment) {
        this.builder = builder;
        this.context = context;
        this.environment = environment;
    }

    public Connection getConnection(ReadGraph g, Resource connection) throws DatabaseException {
        Object handle = this.cache.get((Object)connection);
        if (handle == null) {
            THashSet<Resource> connectionGroup = ContextSupport.getConnectionGroup(g, connection);
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
            int connectionPointCount = 0;
            for (Resource c : connectionGroup) {
                Resource connectionPoint = g.getPossibleObject(c, sr.Binds);
                if (connectionPoint != null) {
                    handle = this.context.context.getConnection(g, connectionPoint);
                }
                connectionPointCount += g.getObjects(c, sr.Connects).size();
            }
            if (handle == null) {
                handle = this.builder.createConnection();
                this.builder.adjustConnectionPointCount(handle, connectionPointCount);
                for (Resource c : connectionGroup) {
                    this.cache.put((Object)c, handle);
                }
            } else {
                this.builder.adjustConnectionPointCount(handle, connectionPointCount - 1);
            }
        }
        return (Connection)handle;
    }

    public static THashSet<Resource> getConnectionGroup(ReadGraph g, Resource connection) throws DatabaseException {
        THashSet connectionGroup = new THashSet();
        connectionGroup.add((Object)connection);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource join : g.getObjects(connection, sr.IsJoinedBy)) {
            for (Resource otherConnection : g.getObjects(join, sr.Joins)) {
                if (connection.equals(otherConnection)) continue;
                ContextSupport.getConnectionGroup(g, otherConnection, (THashSet<Resource>)connectionGroup, join);
            }
        }
        return connectionGroup;
    }

    private static void getConnectionGroup(ReadGraph g, Resource connection, THashSet<Resource> connectionGroup, Resource visitedJoin) throws DatabaseException {
        if (connectionGroup.add((Object)connection)) {
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
            for (Resource join : g.getObjects(connection, sr.IsJoinedBy)) {
                if (join.equals(visitedJoin)) continue;
                for (Resource otherConnection : g.getObjects(join, sr.Joins)) {
                    if (connection.equals(otherConnection)) continue;
                    ContextSupport.getConnectionGroup(g, otherConnection, connectionGroup, join);
                }
            }
        }
    }

    public Connection getConnectionPoint(ReadGraph g, Resource component, Resource connectionPoint) throws DatabaseException {
        Collection connections = g.getObjects(component, connectionPoint);
        if (connections.isEmpty()) {
            return null;
        }
        if (connections.size() == 1) {
            return this.getConnection(g, (Resource)connections.iterator().next());
        }
        ArrayList<Connection> cs = new ArrayList<Connection>(connections.size());
        for (Resource connection : connections) {
            cs.add(this.getConnection(g, connection));
        }
        return this.builder.mergeConnections(cs);
    }

    public ComponentTypeContext<Connection> getContext() {
        return this.context;
    }

    public EnvironmentDescription<ComponentTypeContext<Connection>> getEnvironment() {
        return this.environment;
    }
}

