/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.synchronization.internal;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModelInstances;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ManagementSupport;
import org.simantics.layer0.Layer0;
import org.simantics.structural.flattening.synchronization.StructuralUpdater;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.genericrelations.StructuralChanges;

public class ChangeMetadataProcessor<FlatConfiguration, FlatComposite extends FlatConfiguration, FlatComponent extends FlatConfiguration, Connection> {
    private static final boolean DEBUG = false;
    ReadGraph g;
    Layer0 L0;
    StructuralResource2 STR;
    StructuralUpdater<FlatConfiguration, FlatComposite, FlatComponent, Connection> updater;
    Resource rootResource;
    FlatConfiguration root;
    THashMap<Resource, FlatConfiguration[]> correspondenceMap;
    TObjectIntHashMap<FlatConfiguration> changeFlags = new TObjectIntHashMap();
    final FlatConfiguration[] NOTHING = new Object[0];

    public ChangeMetadataProcessor(ReadGraph g, StructuralUpdater<FlatConfiguration, FlatComposite, FlatComponent, Connection> updater, Resource rootResource, FlatConfiguration root) throws DatabaseException {
        this.g = g;
        this.L0 = Layer0.getInstance((ReadGraph)g);
        this.STR = StructuralResource2.getInstance((ReadGraph)g);
        this.updater = updater;
        this.rootResource = rootResource;
        this.root = root;
        this.correspondenceMap = this.initializeCorrespondenceMap();
    }

    private THashMap<Resource, FlatConfiguration[]> initializeCorrespondenceMap() throws DatabaseException {
        THashMap map = new THashMap();
        ChangeMetadataProcessor.addCorrespondence(map, this.rootResource, this.root);
        this.addComponentTypeRoots(map, this.root);
        final THashMap result = new THashMap();
        map.forEachEntry(new TObjectObjectProcedure<Resource, ArrayList<FlatConfiguration>>(){

            public boolean execute(Resource a, ArrayList<FlatConfiguration> b) {
                result.put((Object)a, (Object)b.toArray(new Object[b.size()]));
                return true;
            }
        });
        return result;
    }

    private static <FlatConfiguration> void addCorrespondence(THashMap<Resource, ArrayList<FlatConfiguration>> map, Resource resource, FlatConfiguration conf) {
        ArrayList<FlatConfiguration> confs = (ArrayList<FlatConfiguration>)map.get((Object)resource);
        if (confs == null) {
            confs = new ArrayList<FlatConfiguration>(1);
            map.put((Object)resource, confs);
        }
        confs.add(conf);
    }

    private void addComponentTypeRoots(THashMap<Resource, ArrayList<FlatConfiguration>> map, FlatConfiguration conf) throws DatabaseException {
        if (this.updater.isComposite(conf)) {
            FlatConfiguration composite = conf;
            Resource sourceType = this.updater.getSourceType(composite);
            if (sourceType != null) {
                Resource definition = this.g.getPossibleObject(sourceType, this.STR.IsDefinedBy);
                if (definition != null) {
                    ChangeMetadataProcessor.addCorrespondence(map, definition, conf);
                } else {
                    System.err.println("NOTE: source type has disappeared: " + NameUtils.getSafeName((ReadGraph)this.g, (Resource)sourceType, (boolean)true) + " (URI=" + this.g.getPossibleURI(sourceType) + ")");
                }
            }
            for (FlatConfiguration child : this.updater.getChildMap(composite).values()) {
                this.addComponentTypeRoots(map, child);
            }
        }
    }

    private FlatConfiguration[] getCorrespondence(Resource resource) throws DatabaseException {
        Object[] result = (Object[])this.correspondenceMap.get((Object)resource);
        if (result == null) {
            Resource parent = this.g.getPossibleObject(resource, this.L0.PartOf);
            if (parent == null) {
                this.correspondenceMap.put((Object)resource, this.NOTHING);
                return this.NOTHING;
            }
            FlatConfiguration[] parentCorrespondence = this.getCorrespondence(parent);
            if (parentCorrespondence == this.NOTHING) {
                this.correspondenceMap.put((Object)resource, this.NOTHING);
                return this.NOTHING;
            }
            String name = (String)this.g.getPossibleRelatedValue(resource, this.L0.HasName, (Binding)Bindings.STRING);
            if (name == null) {
                return this.NOTHING;
            }
            result = new Object[parentCorrespondence.length];
            int i = 0;
            FlatConfiguration[] FlatConfigurationArray = parentCorrespondence;
            int n = parentCorrespondence.length;
            int n2 = 0;
            while (n2 < n) {
                FlatConfiguration child;
                FlatConfiguration parentConf = FlatConfigurationArray[n2];
                if (this.updater.isComposite(parentConf) && (child = this.updater.getChildMap(parentConf).get(name)) != null) {
                    result[i++] = child;
                }
                ++n2;
            }
            if (i < result.length) {
                result = i == 0 ? this.NOTHING : Arrays.copyOf(result, i);
            }
            this.correspondenceMap.put((Object)resource, (Object)result);
        }
        return result;
    }

    private void setChangeFlag(Resource resource, int flag) throws DatabaseException {
        FlatConfiguration[] FlatConfigurationArray = this.getCorrespondence(resource);
        int n = FlatConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlatConfiguration conf = FlatConfigurationArray[n2];
            this.changeFlags.put(conf, this.changeFlags.get(conf) | flag);
            ++n2;
        }
    }

    public static THashSet<Resource> getRelatedConnections(ReadGraph g, Resource connection) throws DatabaseException {
        THashSet connectionGroup = new THashSet();
        ChangeMetadataProcessor.getRelatedConnections(g, connection, (THashSet<Resource>)connectionGroup, null);
        return connectionGroup;
    }

    private static void getRelatedConnections(ReadGraph g, Resource connection, THashSet<Resource> connectionGroup, Resource visitedJoin) throws DatabaseException {
        if (connectionGroup.add((Object)connection)) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
            for (Resource join : g.getObjects(connection, STR.IsJoinedBy)) {
                if (join.equals(visitedJoin)) continue;
                for (Resource otherConnection : g.getObjects(join, STR.Joins)) {
                    if (connection.equals(otherConnection)) continue;
                    ChangeMetadataProcessor.getRelatedConnections(g, otherConnection, connectionGroup, join);
                }
            }
            Resource connectionRelation = g.getPossibleObject(connection, STR.Binds);
            if (connectionRelation != null) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                Resource componentType = g.getSingleObject(connectionRelation, L0.HasDomain);
                Map instances = (Map)g.sync((ReadInterface)new PossibleModelInstances(componentType, componentType));
                for (Resource instance : instances.values()) {
                    for (Resource otherConnection : g.getObjects(instance, connectionRelation)) {
                        ChangeMetadataProcessor.getRelatedConnections(g, otherConnection, connectionGroup, null);
                    }
                }
            }
        }
    }

    private void addChange(StructuralChanges.Change change_, boolean inverted) throws DatabaseException {
        if (change_ instanceof StructuralChanges.ComponentModification) {
            StructuralChanges.ComponentModification change = (StructuralChanges.ComponentModification)change_;
            this.setChangeFlag(change.component, 2);
            Resource parent = this.g.getPossibleObject(change.component, this.L0.PartOf);
            if (parent != null) {
                this.setChangeFlag(parent, 4);
            }
        } else if (change_ instanceof StructuralChanges.ConnectionChange) {
            StructuralChanges.ConnectionChange change = (StructuralChanges.ConnectionChange)change_;
            for (Resource connection : ChangeMetadataProcessor.getRelatedConnections(this.g, change.connection)) {
                for (Resource component : this.g.getObjects(connection, this.STR.Connects)) {
                    this.setChangeFlag(component, 2);
                }
            }
        } else if (change_ instanceof StructuralChanges.ComponentAddition) {
            StructuralChanges.ComponentAddition change = (StructuralChanges.ComponentAddition)change_;
            this.setChangeFlag(change.parent, 4);
            this.setChangeFlag(change.component, 4);
        } else if (change_ instanceof StructuralChanges.ComponentRemoval) {
            StructuralChanges.ComponentRemoval change = (StructuralChanges.ComponentRemoval)change_;
            this.setChangeFlag(change.parent, 4);
            this.setChangeFlag(change.component, 4);
        } else if (change_ instanceof StructuralChanges.ComponentTypeModification) {
            StructuralChanges.ComponentTypeModification change = (StructuralChanges.ComponentTypeModification)change_;
            Map instances = (Map)this.g.sync((ReadInterface)new PossibleModelInstances(change.componentType, change.componentType));
            for (Resource r : instances.values()) {
                this.addChange((StructuralChanges.Change)new StructuralChanges.ComponentModification(r), false);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void processChanges(long from, long to) throws DatabaseException {
        this.processChangeSets(from, to, false);
        this.propagateChanges();
    }

    private void processChangeSets(long from, long to, boolean inverted) throws DatabaseException {
        Collection csis = ((ManagementSupport)this.g.getService(ManagementSupport.class)).getChangeSetIdentifiers(from, to);
        for (ChangeSetIdentifier csi : csis) {
            if (csi.getId() < from) continue;
            this.processChangeSet(csi, inverted);
        }
    }

    private void processChangeSet(ChangeSetIdentifier csi, boolean inverted) throws DatabaseException {
        Map metadata = csi.getMetadata();
        if (metadata != null) {
            byte[] undoMetadata;
            byte[] changesString = (byte[])metadata.get(StructuralChanges.class.getName());
            if (changesString != null && changesString.length > 0) {
                StructuralChanges changes = StructuralChanges.deserialise((Session)this.g.getSession(), (byte[])changesString);
                for (StructuralChanges.Change[] changeArray : changes.modelChanges.values()) {
                    if (changeArray == null) continue;
                    StructuralChanges.Change[] changeArray2 = changeArray;
                    int n = changeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructuralChanges.Change change = changeArray2[n2];
                        this.addChange(change, inverted);
                        ++n2;
                    }
                }
            }
            if ((undoMetadata = (byte[])metadata.get(UndoMetadata.class.getName())) != null && undoMetadata.length > 0) {
                UndoMetadata undo = UndoMetadata.deserialise((Session)this.g.getSession(), (byte[])undoMetadata);
                if (!undo.isRedo()) {
                    inverted = !inverted;
                }
                this.processChangeSets(undo.getBeginCSId(), undo.getEndCSId(), inverted);
            }
        }
    }

    private void propagateChanges() throws DatabaseException {
        this.propagateChanges(this.root, false);
    }

    private boolean propagateChanges(FlatConfiguration conf, boolean parametersChanged) throws DatabaseException {
        if (this.updater.isComposite(conf)) {
            FlatConfiguration composite = conf;
            int currentChangeFlags = this.changeFlags.get(composite);
            if (this.updater.getSourceType(composite) != null) {
                parametersChanged |= (currentChangeFlags & 2) != 0;
            }
            boolean hasModification = false;
            for (FlatConfiguration child : this.updater.getChildMap(composite).values()) {
                hasModification |= this.propagateChanges(child, parametersChanged);
            }
            if (currentChangeFlags > 0) {
                return true;
            }
            if (hasModification) {
                this.changeFlags.put(conf, 1);
                return true;
            }
            return false;
        }
        FlatConfiguration component = conf;
        if (this.changeFlags.containsKey(component)) {
            return true;
        }
        if (parametersChanged && this.updater.isParametrized(component)) {
            this.changeFlags.put(component, 2);
            return true;
        }
        return false;
    }

    public TObjectIntHashMap<FlatConfiguration> getChangeFlags() {
        return this.changeFlags;
    }
}

