/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.synchronization;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.structural.flattening.configuration.StructuralComposite;
import org.simantics.structural.flattening.synchronization.ConnectionBuilder;
import org.simantics.structural.flattening.synchronization.StructuralBuilder;
import org.simantics.structural.flattening.synchronization.StructuralUpdater;
import org.simantics.structural.flattening.synchronization.internal.ChangeMetadataProcessor;
import org.simantics.structural.flattening.types.ComponentType;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.structural2.scl.StructuralConfiguration;

public class SynchronizationSupport {
    private static final boolean DEBUG = false;

    public static <FlatConfiguration, FlatComposite extends FlatConfiguration, FlatComponent extends FlatConfiguration, Connection> FlatConfiguration create(ReadGraph g, StructuralBuilder<FlatConfiguration, FlatComposite, FlatComponent, Connection> builder, FlatComposite parent, String name, StructuralConfiguration<Connection> source_) throws DatabaseException {
        if (source_ instanceof StructuralComposite) {
            StructuralComposite source = (StructuralComposite)source_;
            FlatComposite target = builder.newComposite(parent, name, source);
            for (String childName : source.getChildNames(g)) {
                StructuralConfiguration child = source.getChild(g, childName);
                SynchronizationSupport.create(g, builder, target, childName, child);
            }
            return (FlatConfiguration)target;
        }
        StructuralComponent source = (StructuralComponent)source_;
        Resource type = source.getType(g);
        StructuralComposite<Connection> substructure = SynchronizationSupport.getSubstructure(g, builder, type, source);
        if (substructure != null) {
            FlatConfiguration target = SynchronizationSupport.create(g, builder, parent, name, substructure);
            builder.setSourceType(target, type);
            return target;
        }
        FlatComponent target = builder.newComponent(parent, name, source);
        builder.setParametrized(target, source.isParametrized(g));
        return (FlatConfiguration)target;
    }

    public static <FlatConfiguration, FlatComposite extends FlatConfiguration, FlatComponent extends FlatConfiguration, Connection> FlatConfiguration fullSynchronization(ReadGraph g, StructuralUpdater<FlatConfiguration, FlatComposite, FlatComponent, Connection> updater, FlatComposite parent, String name, StructuralConfiguration<Connection> source_, FlatConfiguration target_) throws DatabaseException {
        if (source_ instanceof StructuralComposite) {
            StructuralComposite source = (StructuralComposite)source_;
            if (updater.isComposite(target_)) {
                FlatConfiguration target = target_;
                Map<String, FlatConfiguration> targetChildMap = updater.getChildMap(target);
                Set<String> sourceChildren = source.getChildNames(g);
                for (String childName : targetChildMap.keySet()) {
                    if (sourceChildren.contains(childName)) continue;
                    updater.remove(g, target, childName);
                }
                for (String childName : sourceChildren) {
                    FlatConfiguration targetChild = targetChildMap.get(childName);
                    StructuralConfiguration sourceChild = source.getChild(g, childName);
                    if (targetChild == null) {
                        updater.create(g, target, childName, sourceChild);
                        continue;
                    }
                    SynchronizationSupport.fullSynchronization(g, updater, target, childName, sourceChild, targetChild);
                }
                updater.setSourceType(target, null);
                return target;
            }
            updater.remove(g, parent, name);
            FlatConfiguration newTarget = SynchronizationSupport.create(g, updater, parent, name, source);
            updater.setSourceType(newTarget, null);
            return newTarget;
        }
        StructuralComponent source = (StructuralComponent)source_;
        Resource type = source.getType(g);
        StructuralComposite<Connection> substructure = SynchronizationSupport.getSubstructure(g, updater, type, source);
        if (substructure != null) {
            FlatConfiguration newTarget = SynchronizationSupport.fullSynchronization(g, updater, parent, name, substructure, target_);
            updater.setSourceType(newTarget, type);
            return newTarget;
        }
        if (updater.isComposite(target_)) {
            updater.remove(g, parent, name);
            FlatConfiguration newTarget = SynchronizationSupport.create(g, updater, parent, name, source);
            updater.setSourceType(newTarget, null);
            return newTarget;
        }
        FlatConfiguration target = target_;
        updater.update(target, source, 0x3FFFFFFF);
        return target;
    }

    private static <FlatConfiguration, FlatComposite extends FlatConfiguration, FlatComponent extends FlatConfiguration, Connection> FlatConfiguration partialSynchronization(ReadGraph g, StructuralUpdater<FlatConfiguration, FlatComposite, FlatComponent, Connection> updater, FlatComposite parent, String name, StructuralConfiguration<Connection> source_, FlatConfiguration target_, TObjectIntHashMap<FlatConfiguration> changeFlags) throws DatabaseException {
        if (source_ instanceof StructuralComposite) {
            StructuralComposite source = (StructuralComposite)source_;
            if (updater.isComposite(target_)) {
                FlatConfiguration target = target_;
                Map<String, FlatConfiguration> targetChildMap = updater.getChildMap(target);
                if (changeFlags.get(target) > 1) {
                    Set<String> sourceChildren = source.getChildNames(g);
                    String[] stringArray = targetChildMap.keySet().toArray(new String[targetChildMap.size()]);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String childName = stringArray[n2];
                        if (!sourceChildren.contains(childName)) {
                            updater.remove(g, target, childName);
                        }
                        ++n2;
                    }
                    for (String childName : sourceChildren) {
                        FlatConfiguration targetChild = targetChildMap.get(childName);
                        StructuralConfiguration sourceChild = source.getChild(g, childName);
                        if (targetChild == null) {
                            updater.create(g, target, childName, sourceChild);
                            continue;
                        }
                        if (changeFlags.get(targetChild) <= 0) continue;
                        SynchronizationSupport.partialSynchronization(g, updater, target, childName, sourceChild, targetChild, changeFlags);
                    }
                } else {
                    for (Map.Entry<String, FlatConfiguration> entry : targetChildMap.entrySet()) {
                        String childName = entry.getKey();
                        FlatConfiguration targetChild = entry.getValue();
                        if (changeFlags.get(targetChild) <= 0) continue;
                        StructuralConfiguration sourceChild = source.getChild(g, childName);
                        SynchronizationSupport.partialSynchronization(g, updater, target, childName, sourceChild, targetChild, changeFlags);
                    }
                }
                updater.setSourceType(target, null);
                return target;
            }
            updater.remove(g, parent, name);
            FlatConfiguration newTarget = SynchronizationSupport.create(g, updater, parent, name, source);
            updater.setSourceType(newTarget, null);
            return newTarget;
        }
        StructuralComponent source = (StructuralComponent)source_;
        Resource type = source.getType(g);
        StructuralComposite<Connection> substructure = SynchronizationSupport.getSubstructure(g, updater, type, source);
        if (substructure != null) {
            FlatConfiguration newTarget = SynchronizationSupport.partialSynchronization(g, updater, parent, name, substructure, target_, changeFlags);
            updater.setSourceType(newTarget, type);
            return newTarget;
        }
        if (updater.isComposite(target_)) {
            updater.remove(g, parent, name);
            FlatConfiguration newTarget = SynchronizationSupport.create(g, updater, parent, name, source);
            updater.setSourceType(newTarget, null);
            return newTarget;
        }
        FlatConfiguration target = target_;
        updater.update(target, source, changeFlags.get(target));
        return target;
    }

    public static <FlatConfiguration, FlatComposite extends FlatConfiguration, FlatComponent extends FlatConfiguration, Connection> FlatConfiguration partialSynchronization(ReadGraph g, StructuralUpdater<FlatConfiguration, FlatComposite, FlatComponent, Connection> updater, FlatComposite parent, String name, StructuralConfiguration<Connection> source_, FlatConfiguration target_, long fromRevision, long toRevision) throws DatabaseException {
        Resource root = source_.getResource();
        if (root == null) {
            throw new NullPointerException();
        }
        ChangeMetadataProcessor<FlatConfiguration, FlatComposite, FlatComponent, Connection> metadataProcessor = new ChangeMetadataProcessor<FlatConfiguration, FlatComposite, FlatComponent, Connection>(g, updater, root, target_);
        metadataProcessor.processChanges(fromRevision, toRevision);
        TObjectIntHashMap<FlatConfiguration> changeFlags = metadataProcessor.getChangeFlags();
        return SynchronizationSupport.partialSynchronization(g, updater, parent, name, source_, target_, changeFlags);
    }

    public static long getCurrentRevisionId(ReadGraph g, long current) {
        try {
            ManagementSupport ms = (ManagementSupport)g.getService(ManagementSupport.class);
            long head = ms.getHeadRevisionId();
            if (current == head) {
                return head;
            }
            Collection csis = ms.getChangeSets(current + 1L, Long.MAX_VALUE);
            long got = 0L;
            for (ChangeSetIdentifier csi : csis) {
                if (csi.getId() <= got) continue;
                got = csi.getId();
            }
            if (head != got) {
                new Exception("Change set bookkeeping was corrupted (current=" + current + ", head=" + head + ", got=" + got + ")").printStackTrace();
            }
            return Math.max(got, current);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static <Connection> StructuralComposite<Connection> getSubstructure(ReadGraph g, ConnectionBuilder<Connection> builder, Resource type, StructuralComponent<Connection> component) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (g.hasStatement(type, sr.IsDefinedBy)) {
            ComponentType componentType = (ComponentType)g.adapt(type, ComponentType.class);
            return componentType.getConfiguration(g, component, builder);
        }
        return null;
    }
}

