/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.internal;

import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.expressions.ContextualValue;
import org.simantics.scl.expressions.EnvironmentDescription;
import org.simantics.structural.flattening.configuration.StructuralComposite;
import org.simantics.structural.flattening.configuration.graph.GraphComposite;
import org.simantics.structural.flattening.internal.ComponentTypeInterfaceQuery;
import org.simantics.structural.flattening.synchronization.ConnectionBuilder;
import org.simantics.structural.flattening.types.ComponentType;
import org.simantics.structural.flattening.types.ComponentTypeContext;
import org.simantics.structural.flattening.types.ContextSupport;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.StructuralComponent;

public class StandardComponentType<Connection>
implements ComponentType<Connection> {
    Resource componentType;

    public StandardComponentType(Resource componentType) {
        this.componentType = componentType;
    }

    @Override
    public StructuralComposite<Connection> getConfiguration(ReadGraph g, StructuralComponent<Connection> context, ConnectionBuilder<Connection> builder) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        Resource configuration = g.getSingleObject(this.componentType, sr.IsDefinedBy);
        final Map map = (Map)g.syncRequest(new ComponentTypeInterfaceQuery(this.componentType));
        EnvironmentDescription environment = new EnvironmentDescription<ComponentTypeContext<Connection>>(){

            public ContextualValue<ComponentTypeContext<Connection>> resolve(String name) {
                return (ContextualValue)map.get(name);
            }
        };
        return new GraphComposite<Connection>(configuration, new ContextSupport<Connection>(builder, new ComponentTypeContext<Connection>(g, context), environment), true);
    }
}

