/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.internal;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.expressions.ContextualValue;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.SCLTypeParseException;
import org.simantics.structural.flattening.internal.InterfaceValue;
import org.simantics.structural.flattening.types.ComponentTypeContext;

public class ComponentTypeInterfaceQuery<Connection>
extends UnaryRead<Resource, Map<String, ContextualValue<ComponentTypeContext<Connection>>>> {
    public ComponentTypeInterfaceQuery(Resource parameter) {
        super((Object)parameter);
    }

    public Map<String, ContextualValue<ComponentTypeContext<Connection>>> perform(ReadGraph graph) throws DatabaseException {
        THashMap result = new THashMap();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource relation : graph.getObjects((Resource)this.parameter, L0.DomainOf)) {
            if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
            String name = (String)graph.getRelatedValue(relation, L0.HasName);
            String typeString = (String)graph.getRelatedValue(relation, L0.RequiresValueType);
            try {
                Type type = Types.parseType((String)typeString);
                result.put((Object)name, new InterfaceValue(relation, type));
            }
            catch (SCLTypeParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

