/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.configuration.map;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.utils.datastructures.Pair;

public class MapComponent<Connection>
extends StructuralComponent<Connection> {
    Resource type;
    THashMap<Resource, Variant> attributes = new THashMap();
    THashMap<Resource, Connection> connections = new THashMap();
    boolean parametrized;

    public MapComponent(Resource type) {
        this.type = type;
    }

    public Resource getType(ReadGraph g) {
        return this.type;
    }

    public Object getValue(ReadGraph g, Resource attribute, Binding binding) throws DatabaseException, AdaptException {
        Variant value = (Variant)this.attributes.get((Object)attribute);
        if (value == null) {
            return null;
        }
        return value.getValue(binding);
    }

    public void addAttribute(Resource attribute, Object value, Binding binding) {
        this.addAttribute(attribute, new Variant(binding, value));
    }

    public void addAttribute(Resource attribute, Variant variant) {
        this.attributes.put((Object)attribute, (Object)variant);
    }

    public void setParametrized(boolean parametrized) {
        this.parametrized = parametrized;
    }

    public boolean isParametrized(ReadGraph g) {
        return this.parametrized;
    }

    public Connection getConnection(ReadGraph g, Resource connectionPoint) throws DatabaseException {
        return (Connection)this.connections.get((Object)connectionPoint);
    }

    public Resource getResource() {
        return null;
    }

    public List<Pair<Resource, Connection>> getConnections(final ReadGraph g, final Resource connectionPoint) throws DatabaseException {
        final ArrayList<Pair<Resource, Connection>> result = new ArrayList<Pair<Resource, Connection>>();
        try {
            this.connections.forEachEntry(new TObjectObjectProcedure<Resource, Connection>(){

                public boolean execute(Resource cp, Connection c) {
                    try {
                        if (g.isSubrelationOf(cp, connectionPoint)) {
                            result.add(Pair.make((Object)cp, c));
                        }
                        return true;
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeDatabaseException((Throwable)e);
                    }
                }
            });
        }
        catch (RuntimeDatabaseException e) {
            throw (DatabaseException)e.getCause();
        }
        return result;
    }

    public StructuralComponent<Connection> getContext() {
        throw new UnsupportedOperationException();
    }
}

