/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.configuration.graph;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.structural.flattening.configuration.StructuralComposite;
import org.simantics.structural.flattening.configuration.graph.GraphComponent;
import org.simantics.structural.flattening.types.ComponentTypeContext;
import org.simantics.structural.flattening.types.ContextSupport;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.structural2.scl.StructuralConfiguration;

public class GraphComposite<Connection>
extends StructuralComposite<Connection> {
    Resource resource;
    ContextSupport<Connection> support;
    volatile Map<String, Resource> cachedChildMap;
    boolean isRoot;

    public GraphComposite(Resource resource, ContextSupport<Connection> support, boolean isRoot) {
        this.resource = resource;
        this.support = support;
        this.isRoot = isRoot;
    }

    public GraphComposite(Resource resource, ContextSupport<Connection> support) {
        this(resource, support, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Resource> getChildMap(ReadGraph graph) throws DatabaseException {
        THashMap result = this.cachedChildMap;
        if (result == null) {
            GraphComposite graphComposite = this;
            synchronized (graphComposite) {
                result = this.cachedChildMap;
                if (result == null) {
                    Map allChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(this.resource));
                    result = new THashMap(allChildren.size());
                    StructuralResource2 str = StructuralResource2.getInstance((ReadGraph)graph);
                    for (Map.Entry entry : allChildren.entrySet()) {
                        if (!graph.getTypes((Resource)entry.getValue()).contains(str.Component)) continue;
                        result.put((String)entry.getKey(), (Resource)entry.getValue());
                    }
                    this.cachedChildMap = result;
                }
            }
        }
        return result;
    }

    @Override
    public Set<String> getChildNames(ReadGraph g) throws DatabaseException {
        return this.getChildMap(g).keySet();
    }

    @Override
    public StructuralConfiguration<Connection> getChild(ReadGraph g, String name) throws DatabaseException {
        Map<String, Resource> childMap = this.getChildMap(g);
        Resource childResource = childMap.get(name);
        if (childResource == null) {
            return null;
        }
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (g.getTypes(childResource).contains(sr.Composite)) {
            return new GraphComposite<Connection>(childResource, this.support);
        }
        return new GraphComponent<Connection>(childResource, this.support);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getInstanceResource() {
        if (this.isRoot) {
            if (this.support == null) {
                return this.getResource();
            }
            ComponentTypeContext<Connection> context = this.support.getContext();
            if (context == null) {
                return this.getResource();
            }
            if (context.context == null) {
                return this.getResource();
            }
            return context.context.getResource();
        }
        return this.getResource();
    }

    public StructuralComponent<Connection> getContext() {
        return this.support.getContext().context;
    }
}

