/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.flattening.configuration.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.scl.expressions.datatype.DatatypeConversion;
import org.simantics.scl.types.Type;
import org.simantics.structural.flattening.configuration.graph.CompileSCLValueRequestDeprecated;
import org.simantics.structural.flattening.types.ComponentTypeContext;
import org.simantics.structural.flattening.types.ContextSupport;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.CompiledExpression;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.utils.datastructures.Pair;

public class GraphComponent<Connection>
extends StructuralComponent<Connection> {
    Resource resource;
    ContextSupport<Connection> support;

    public GraphComponent(Resource resource, ContextSupport<Connection> support) {
        this.resource = resource;
        this.support = support;
    }

    public Resource getType(ReadGraph g) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        return g.getSingleType(this.resource, sr.Component);
    }

    public Object getValue(ReadGraph g, Resource attribute, Binding binding) throws DatabaseException, AdaptException {
        Resource valueResource = g.getPossibleObject(this.resource, attribute);
        if (valueResource == null) {
            return null;
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        if (g.isInstanceOf(valueResource, STR.SCLValue)) {
            Type expectedType;
            try {
                expectedType = DatatypeConversion.convertDatatypeToType((Datatype)binding.type());
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
                return null;
            }
            CompiledExpression expression = (CompiledExpression)g.syncRequest((Read)new CompileSCLValueRequestDeprecated(valueResource, expectedType));
            if (expression == null) {
                return null;
            }
            return expression.evaluate(g, this.support.getContext().context);
        }
        if (!g.hasValue(valueResource)) {
            return null;
        }
        Datatype type = g.getDataType(valueResource);
        Binding domain = Bindings.getBinding((Datatype)type);
        Object value = g.getValue(valueResource, domain);
        if (domain == binding) {
            return value;
        }
        if (value instanceof Number && binding instanceof NumberBinding) {
            try {
                return ((NumberBinding)binding).create((Number)value);
            }
            catch (BindingException e) {
                throw new AdaptException((Throwable)e);
            }
        }
        if (domain instanceof FloatArrayBinding) {
            domain = Bindings.FLOAT_ARRAY;
        } else if (domain instanceof DoubleArrayBinding) {
            domain = Bindings.DOUBLE_ARRAY;
        }
        return Bindings.adapt((Object)value, (Binding)domain, (Binding)binding);
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isParametrized(ReadGraph g) throws DatabaseException {
        return true;
    }

    public Connection getConnection(ReadGraph g, Resource connectionPoint) throws DatabaseException {
        return this.support.getConnectionPoint(g, this.resource, connectionPoint);
    }

    public List<Pair<Resource, Connection>> getConnections(ReadGraph g, Resource connectionPoint) throws DatabaseException {
        Collection statements = g.getStatements(this.resource, connectionPoint);
        if (statements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Resource, Connection>> result = new ArrayList<Pair<Resource, Connection>>(statements.size());
        for (Statement stat : statements) {
            result.add(Pair.make((Object)stat.getPredicate(), this.support.getConnection(g, stat.getObject())));
        }
        return result;
    }

    public StructuralComponent<Connection> getContext() {
        ComponentTypeContext<Connection> ctx = this.support.getContext();
        return ctx != null ? ctx.context : null;
    }
}

