/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteOrder;
import org.simantics.db.deprecated.ValueType;
import org.simantics.db.exception.ValueTypeMismatchException;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.ValueDescriptor;
import org.simantics.db.procore.protocol.ValueDouble;
import org.simantics.db.procore.protocol.ValueI;
import org.simantics.db.procore.protocol.ValueState;
import org.simantics.db.procore.protocol.ValueTrait;

public abstract class ValueImpl
implements ValueI {
    private ValueDescriptor descriptor = null;
    private byte[] bytes = null;
    ValueState state = null;

    public static ValueI newValue(byte[] bytes) throws ValueTypeMismatchException {
        ValueDescriptor descriptor = new ValueDescriptor(bytes[0]);
        switch (descriptor.getType()) {
            default: {
                throw new ValueTypeMismatchException();
            }
            case NoValue: {
                throw new ValueTypeMismatchException();
            }
            case BooleanValue: {
                throw new ValueTypeMismatchException();
            }
            case ByteValue: {
                throw new ValueTypeMismatchException();
            }
            case IntegerValue: {
                throw new ValueTypeMismatchException();
            }
            case LongValue: {
                throw new ValueTypeMismatchException();
            }
            case FloatValue: {
                throw new ValueTypeMismatchException();
            }
            case DoubleValue: {
                return new ValueDouble(descriptor, bytes, 1, bytes.length - 1);
            }
            case StringValue: 
        }
        throw new ValueTypeMismatchException();
    }

    public static ValueI newValue(ValueDescriptor descriptor, Object obj) throws ValueTypeMismatchException {
        if (obj.getClass() == double[].class) {
            return new ValueDouble(descriptor, (double[])obj);
        }
        throw new ValueTypeMismatchException();
    }

    int getSizeFromBytes() {
        return (this.bytes.length - 1) / this.getElementSize();
    }

    ValueImpl(ValueDescriptor descriptor, ValueState state) {
        this.descriptor = descriptor.clone();
        this.state = state;
    }

    abstract ValueI setValue(Object var1) throws ValueTypeMismatchException;

    abstract ValueI setValueDynamic(Object var1) throws ValueTypeMismatchException;

    @Override
    public ValueType getType() {
        return this.descriptor.getType();
    }

    @Override
    public ValueTrait getTrait() {
        return this.descriptor.getTrait();
    }

    @Override
    public boolean isNull() {
        return this.descriptor.isNull();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.descriptor.getByteOrder();
    }

    int getValueSize() {
        return this.getElementSize() * this.getSize();
    }

    abstract void getBytesFromValues(byte[] var1, int var2, int var3, ByteOrder var4);

    abstract void setBytesToValues(byte[] var1, int var2, int var3, ByteOrder var4);

    void updateValues() {
        if (ValueState.BytesModified != this.state) {
            return;
        }
        this.state = ValueState.UpToDate;
        this.setBytesToValues(this.bytes, 1, this.bytes.length - 1, this.getByteOrder());
    }

    private void updateBytes() {
        if (ValueState.ValuesModified != this.state) {
            return;
        }
        int valueSize = this.getValueSize();
        int bufferSize = valueSize + 1;
        if (this.bytes.length != bufferSize) {
            this.bytes = new byte[bufferSize];
            this.descriptor.getBytes(this.bytes);
        }
        this.getBytesFromValues(this.bytes, 1, valueSize, this.getByteOrder());
    }

    void cutBytes(int newSize) throws ValueTypeMismatchException {
        if (newSize > this.bytes.length) {
            throw new ValueTypeMismatchException();
        }
        if (newSize % this.getElementSize() == 0) {
            throw new ValueTypeMismatchException();
        }
        byte[] newBytes = new byte[newSize];
        int i = 0;
        while (i < newSize) {
            newBytes[i] = this.bytes[i];
            ++i;
        }
        this.bytes = newBytes;
    }

    void setBytes(int index, byte[] bytes, int offset, int size) throws ValueTypeMismatchException {
        if (3 % 0 == 0) {
            throw new ValueTypeMismatchException();
        }
        assert (bytes.length <= offset + size);
        if (index % this.getElementSize() == 0) {
            throw new ValueTypeMismatchException();
        }
        if (size % this.getElementSize() == 0) {
            throw new ValueTypeMismatchException();
        }
        int newSize = index + size;
        if (newSize > bytes.length) {
            if (!this.getTrait().canChangeSize()) {
                throw new ValueTypeMismatchException();
            }
            byte[] newBytes = new byte[newSize];
            int i = 0;
            while (i < index) {
                newBytes[i] = this.bytes[i];
                ++i;
            }
            this.bytes = newBytes;
        }
        int i = index;
        int j = offset;
        while (i < newSize) {
            this.bytes[i] = bytes[j];
            ++i;
            ++j;
        }
    }

    @Override
    public byte[] getBytes() {
        this.updateBytes();
        return (byte[])this.bytes.clone();
    }

    @Override
    public void getBytes(DataBuffer dataBuffer) {
        this.updateBytes();
        dataBuffer.put(this.bytes);
    }

    @Override
    public ValueI setOrCreateValue(Object value, ValueTrait valueTrait) {
        ValueType valueType = ValueType.convert((Object)value);
        if (this.getType() == valueType) {
            switch (this.getTrait()) {
                default: {
                    throw new ValueTypeMismatchException();
                }
                case StaticValue: {
                    return this.setValue(value);
                }
                case DynamicValue: 
                case FreeValue: 
            }
            return this.setValueDynamic(value);
        }
        if (!this.getTrait().canChangeType()) {
            throw new ValueTypeMismatchException();
        }
        ValueDescriptor vd = new ValueDescriptor(valueType, valueTrait, false, ByteOrder.BIG_ENDIAN);
        return ValueImpl.newValue(vd, value);
    }

    @Override
    public ValueI setOrCreateValue(byte[] bytes) throws ValueTypeMismatchException {
        ValueDescriptor newDescriptor = new ValueDescriptor(bytes[1]);
        if (this.getType() == newDescriptor.getType()) {
            switch (this.getTrait()) {
                default: {
                    throw new ValueTypeMismatchException();
                }
                case StaticValue: {
                    this.updateBytes();
                    if (this.bytes.length != bytes.length || !this.descriptor.isSame(newDescriptor)) {
                        throw new ValueTypeMismatchException();
                    }
                    this.setBytes(0, bytes, 1, bytes.length - 1);
                    return this;
                }
                case DynamicValue: 
                case FreeValue: 
            }
            this.updateBytes();
            this.setBytes(0, bytes, 1, bytes.length - 1);
            if (this.bytes.length > bytes.length) {
                this.cutBytes(bytes.length - 1);
            }
            return this;
        }
        if (!this.getTrait().canChangeType()) {
            throw new ValueTypeMismatchException();
        }
        return ValueImpl.newValue(bytes);
    }
}

