/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.simantics.db.deprecated.ValueType;
import org.simantics.db.exception.ValueTypeMismatchException;
import org.simantics.db.procore.protocol.ValueDescriptor;
import org.simantics.db.procore.protocol.ValueI;
import org.simantics.db.procore.protocol.ValueImpl;
import org.simantics.db.procore.protocol.ValueState;

public class ValueDouble
extends ValueImpl {
    private double[] values;

    private double[] setValueCheck(Object value) {
        if (value.getClass() != double[].class) {
            throw new ValueTypeMismatchException();
        }
        double[] t = (double[])value;
        return t;
    }

    @Override
    void getBytesFromValues(byte[] buffer, int offset, int length, ByteOrder byteOrder) {
        ByteBuffer t = ByteBuffer.wrap(buffer, offset, length);
        t.order(byteOrder);
        t.asDoubleBuffer().put(this.values);
    }

    @Override
    void setBytesToValues(byte[] buffer, int offset, int length, ByteOrder byteOrder) {
        int newSize = length / this.getElementSize();
        if (this.values.length != newSize) {
            this.values = new double[newSize];
        }
        ByteBuffer t = ByteBuffer.wrap(buffer, offset, length);
        t.order(byteOrder);
        t.asDoubleBuffer().get(this.values);
    }

    @Override
    ValueI setValue(Object value) throws ValueTypeMismatchException {
        double[] t = this.setValueCheck(value);
        this.updateValues();
        if (t.length != this.values.length) {
            throw new ValueTypeMismatchException();
        }
        return this.setValue(0, value, 0, t.length);
    }

    @Override
    ValueI setValueDynamic(Object value) throws ValueTypeMismatchException {
        double[] t = this.setValueCheck(value);
        this.updateValues();
        if (t.length != this.values.length) {
            if (this.getTrait().canChangeSize()) {
                this.values = new double[t.length];
            } else {
                throw new ValueTypeMismatchException();
            }
        }
        return this.setValue(0, value, 0, t.length);
    }

    public ValueDouble(ValueDescriptor descriptor, byte[] bytes, int offset, int size) throws ValueTypeMismatchException {
        super(descriptor, ValueState.BytesModified);
        this.setBytes(0, bytes, offset, size);
    }

    public ValueDouble(ValueDescriptor descriptor, double[] values) throws ValueTypeMismatchException {
        super(descriptor, ValueState.ValuesModified);
        if (descriptor.getType() != ValueType.DoubleValue) {
            throw new ValueTypeMismatchException();
        }
        this.values = (double[])values.clone();
    }

    @Override
    public int getElementSize() {
        return 8;
    }

    @Override
    public int getSize() {
        if (ValueState.BytesModified != this.state) {
            return this.values.length;
        }
        return this.getSizeFromBytes();
    }

    @Override
    public void getValue(int index, Object value, int offset, int size) throws ValueTypeMismatchException, IndexOutOfBoundsException {
        if (value.getClass() != double[].class) {
            throw new ValueTypeMismatchException();
        }
        double[] t = (double[])value;
        int limit = index + size;
        this.updateValues();
        if (limit > this.values.length || offset + size > t.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = index;
        int j = offset;
        while (i < limit) {
            t[j] = this.values[i];
            ++i;
            ++j;
        }
    }

    @Override
    public ValueI setValue(int index, Object value, int offset, int size) {
        double[] t = this.setValueCheck(value);
        int limit = index + size;
        this.updateValues();
        if (limit > this.values.length || offset + size > t.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = index;
        int j = offset;
        while (i < limit) {
            this.values[i] = t[j];
            ++i;
            ++j;
        }
        assert (ValueState.BytesModified != this.state);
        this.state = ValueState.ValuesModified;
        return this;
    }
}

