/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteOrder;
import org.simantics.db.deprecated.ValueType;
import org.simantics.db.exception.ValueTypeMismatchException;
import org.simantics.db.procore.protocol.ValueTrait;

public class ValueDescriptor
implements Cloneable {
    static final int SIZE = 1;
    private byte type;

    ValueDescriptor(byte type) throws ValueTypeMismatchException {
        if ((type & 8) != 0) {
            throw new ValueTypeMismatchException();
        }
        this.type = type;
    }

    public ValueDescriptor(ValueType valueType, ValueTrait valueTrait, boolean isNull, ByteOrder byteOrder) throws ValueTypeMismatchException {
        this.type = (byte)(valueType.getBits() | valueTrait.getBits());
        if (isNull) {
            this.type = (byte)(this.type | 0x40);
        }
        if (ByteOrder.BIG_ENDIAN == byteOrder) {
            this.type = (byte)(this.type | 0x80);
        }
    }

    public ValueDescriptor clone() {
        return new ValueDescriptor(this.type);
    }

    boolean isSame(ValueDescriptor valueDescriptor) {
        return this.type == valueDescriptor.type;
    }

    ValueType getType() {
        return ValueType.convert((byte)this.type);
    }

    ValueTrait getTrait() {
        return ValueTrait.convert(this.type);
    }

    boolean isNull() {
        return (this.type & 0x80) != 0;
    }

    ByteOrder getByteOrder() {
        if (this.type > 0) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    void getBytes(byte[] bytes) {
        bytes[0] = this.type;
    }
}

