/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteOrder;
import org.simantics.db.procore.protocol.BooleanValue;
import org.simantics.db.procore.protocol.ByteValue;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.DoubleValue;
import org.simantics.db.procore.protocol.FloatValue;
import org.simantics.db.procore.protocol.IntValue;
import org.simantics.db.procore.protocol.LongValue;
import org.simantics.db.procore.protocol.NullValue;
import org.simantics.db.procore.protocol.StringValue;

public abstract class Value {
    public static final int Boolean = 0;
    public static final int Byte = 1;
    public static final int Int = 2;
    public static final int Long = 3;
    public static final int Float = 4;
    public static final int Double = 5;
    public static final int String = 6;
    public static final int Null = 7;
    public static final int NumberOfVariableTypes = 8;

    public void serialize(DataBuffer dataBuffer) {
        throw new IllegalStateException();
    }

    public static byte[] getBytes(Object object) {
        DataBuffer t = new DataBuffer(DataBuffer.Allocation.JavaAllocation);
        t.order(ByteOrder.LITTLE_ENDIAN);
        Value.serialize(t, object);
        return t.getBytes();
    }

    public static void serialize(DataBuffer dataBuffer, Object o) {
        Class<?> clazz = o.getClass();
        if (clazz == boolean[].class) {
            boolean[] values = (boolean[])o;
            dataBuffer.put((byte)0);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == byte[].class) {
            byte[] values = (byte[])o;
            dataBuffer.put((byte)1);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == int[].class) {
            int[] values = (int[])o;
            dataBuffer.put((byte)2);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == long[].class) {
            long[] values = (long[])o;
            dataBuffer.put((byte)3);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == float[].class) {
            float[] values = (float[])o;
            dataBuffer.put((byte)4);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == double[].class) {
            double[] values = (double[])o;
            dataBuffer.put((byte)5);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        if (clazz == String[].class) {
            String[] values = (String[])o;
            dataBuffer.put((byte)6);
            dataBuffer.put(values.length);
            int i = 0;
            while (i < values.length) {
                dataBuffer.put(values[i]);
                ++i;
            }
            return;
        }
        throw new Error("Unknown object type " + clazz);
    }

    public static Object deserialize(byte[] data) {
        assert (data != null);
        assert (data.length > 0);
        DataBuffer dataBuffer = new DataBuffer(data);
        dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte type = dataBuffer.get((byte)0);
        assert (type != 7);
        int size = dataBuffer.get(0);
        switch (type) {
            case 0: {
                return BooleanValue.deserialize(size, dataBuffer);
            }
            case 1: {
                return ByteValue.deserialize(size, dataBuffer);
            }
            case 2: {
                return IntValue.deserialize(size, dataBuffer);
            }
            case 3: {
                return LongValue.deserialize(size, dataBuffer);
            }
            case 4: {
                return FloatValue.deserialize(size, dataBuffer);
            }
            case 5: {
                return DoubleValue.deserialize(size, dataBuffer);
            }
            case 6: {
                return StringValue.deserialize(size, dataBuffer);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Value deserialize(DataBuffer dataBuffer) {
        byte type = dataBuffer.get((byte)0);
        if (type == 7) {
            return new NullValue();
        }
        int size = dataBuffer.get(0);
        switch (type) {
            case 0: {
                return new BooleanValue(size, dataBuffer);
            }
            case 1: {
                return new ByteValue(size, dataBuffer);
            }
            case 2: {
                return new IntValue(size, dataBuffer);
            }
            case 3: {
                return new LongValue(size, dataBuffer);
            }
            case 4: {
                return new FloatValue(size, dataBuffer);
            }
            case 5: {
                return new DoubleValue(size, dataBuffer);
            }
            case 6: {
                return new StringValue(size, dataBuffer);
            }
            case 7: {
                return new NullValue();
            }
        }
        throw new IllegalArgumentException();
    }
}

