/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.Value;
import org.simantics.db.procore.protocol.ValueDescriptor;

public class StringValue
extends Value {
    String[] values;
    ValueDescriptor descriptor;

    public StringValue(String[] values) {
        this.values = values;
    }

    StringValue(int size, DataBuffer dataBuffer) {
        this.values = new String[size];
        int i = 0;
        while (i < size) {
            this.values[i] = dataBuffer.get(this.values[i]);
            ++i;
        }
    }

    public static String[] deserialize(int size, DataBuffer dataBuffer) {
        String[] values = new String[size];
        int i = 0;
        while (i < size) {
            values[i] = dataBuffer.get(values[i]);
            ++i;
        }
        return values;
    }

    @Override
    public void serialize(DataBuffer dataBuffer) {
        dataBuffer.put((byte)6);
        dataBuffer.put(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            dataBuffer.put(this.values[i]);
            ++i;
        }
    }

    public String[] getString() {
        return this.values;
    }

    public void setString(String[] a) {
        this.values = a;
    }

    public String toString() {
        return this.values[0];
    }
}

