/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procore.protocol.ConnectionImpl;
import org.simantics.db.procore.protocol.Connector;
import org.simantics.db.procore.protocol.GraphClient;
import org.simantics.db.procore.protocol.GraphClientEventHandler;
import org.simantics.db.procore.protocol.GraphClientImpl;
import org.simantics.db.procore.protocol.NotConnectedException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionIOException;
import org.simantics.db.procore.protocol.SessionManager;

public class SessionManagerImpl
implements SessionManager {
    public static boolean DEBUG = false;
    public static Properties nullProperties = new Properties();
    Manager manager = new Manager();
    Thread thread;
    boolean stop = false;
    static SessionManagerImpl sessionManagerImpl;
    private Listener listener;
    protected List<Connector> connectors = Collections.synchronizedList(new LinkedList());

    static {
        nullProperties.put("log4j.rootCategory", "INFO, default");
        nullProperties.put("log4j.appender.default", "org.apache.log4j.varia.NullAppender");
        sessionManagerImpl = null;
    }

    public static SessionManagerImpl getInstance() throws IOException {
        if (sessionManagerImpl == null) {
            sessionManagerImpl = new SessionManagerImpl();
            sessionManagerImpl.start();
        }
        return sessionManagerImpl;
    }

    SessionManagerImpl() throws IOException {
        this.thread = new Thread((Runnable)this.manager, "Session Manager");
        Logger.defaultLogInfo((String)"SessionManagerImpl.");
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    private void processRead(SelectionKey key) {
        ConnectionImpl c = (ConnectionImpl)key.attachment();
        SocketChannel sc = (SocketChannel)key.channel();
        int ops = key.interestOps() & 0xFFFFFFFE;
        key.interestOps(ops);
        try {
            c.onRead();
        }
        catch (IOException x) {
            if (key.isValid()) {
                key.attach(null);
                key.cancel();
            }
            if (sc.isOpen()) {
                try {
                    sc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            c.onReadFailed(new SessionIOException("Read event handler (onRead) failed.", x));
        }
    }

    void register(Connector c) throws SessionException {
        try {
            boolean connected;
            c.sc = SocketChannel.open();
            c.sc.configureBlocking(false);
            InetSocketAddress addr = c.getSocketAddress();
            if (addr == null) {
                throw new NotConnectedException("Cannot connect to " + c.getStringAddress());
            }
            if (addr.isUnresolved()) {
                addr = new InetSocketAddress(addr.getHostName(), addr.getPort());
            }
            if (connected = c.sc.connect(addr)) {
                Logger.defaultLogTrace((String)"DEBUG: SessionManagerImpl connect ok.");
            }
            this.connectors.add(c);
            this.manager.selector.wakeup();
        }
        catch (IOException e) {
            throw new SessionIOException("Failed to register connector.", e);
        }
    }

    boolean isRegistered(Connector c) {
        return this.connectors.contains(c);
    }

    @Override
    public void start() {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.stop = true;
        this.manager.selector.wakeup();
    }

    @Override
    public GraphClient newGraphClient(GraphClientEventHandler handler) {
        return new GraphClientImpl(this, handler);
    }

    public static interface Listener {
        public void shutdown(GraphClientImpl var1, Throwable var2);

        public void exception(GraphClientImpl var1, Throwable var2);
    }

    protected class Manager
    implements Runnable {
        private Selector selector = Selector.open();

        Manager() throws IOException {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int n = this.selector.select();
                    try {
                        if (n > 0) {
                            this.processSelected();
                        }
                        this.processConnectors();
                        if (!SessionManagerImpl.this.stop) continue;
                        this.selector.close();
                        return;
                    }
                    catch (CancelledKeyException e) {
                        Logger.defaultLogError((String)"Cancelled key in select loop.", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                Logger.defaultLogError((String)"Select loop failed.", (Throwable)x);
                return;
            }
        }

        void processConnectors() throws ClosedChannelException {
            while (SessionManagerImpl.this.connectors.size() > 0) {
                Connector c = SessionManagerImpl.this.connectors.remove(0);
                c.sc.register(this.selector, 8, c);
            }
        }

        void processSelected() {
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey sk = i.next();
                i.remove();
                try {
                    if (!sk.isValid()) {
                        this.processDisconnect(sk);
                        continue;
                    }
                    if (sk.isConnectable()) {
                        this.processConnect(sk);
                        continue;
                    }
                    if (!sk.isReadable()) continue;
                    SessionManagerImpl.this.processRead(sk);
                }
                catch (CancelledKeyException e) {
                    this.processDisconnect(sk);
                }
            }
        }

        private void processDisconnect(SelectionKey key) {
            ConnectionImpl c = (ConnectionImpl)key.attachment();
            if (c == null) {
                return;
            }
            c.onDisconnect();
            key.attach(null);
            key.cancel();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processConnect(SelectionKey key) {
            Connector connector = (Connector)key.attachment();
            SocketChannel sc = (SocketChannel)key.channel();
            try {
                if (!sc.finishConnect()) return;
                int ops = key.interestOps() & 0xFFFFFFF7;
                key.interestOps(ops |= 1);
                ConnectionImpl connection = connector.onConnect(key, SessionManagerImpl.this.listener);
                if (connection == null) {
                    key.attach(null);
                    key.cancel();
                    sc.close();
                    return;
                }
                key.attach(connection);
                return;
            }
            catch (Throwable x) {
                try {
                    if (key.isValid()) {
                        key.attach(null);
                    }
                    key.cancel();
                    try {
                        sc.close();
                    }
                    catch (IOException e) {
                        if (DEBUG) {
                            Logger.defaultLogError((String)"Failed to close connection.", (Throwable)e);
                        }
                    }
                }
                finally {
                    connector.onConnectFailed(new NotConnectedException("Failed to establish connection.", x));
                }
            }
        }
    }
}

