/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.TreeMap;
import org.simantics.db.procore.protocol.AbstractFunction;
import org.simantics.db.procore.protocol.RequestQueue;

class ResponseQueue {
    private TIntObjectHashMap<AbstractFunction> functionMap = new TIntObjectHashMap();

    ResponseQueue() {
    }

    public synchronized int size() {
        return this.functionMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void add(AbstractFunction function) {
        if (!function.hasResponse()) {
            throw new Error("Trying to add illegal function to response queue.");
        }
        int token = function.getToken();
        if (token == 0) {
            throw new Error("Illegal token number.");
        }
        AbstractFunction oldFunction = (AbstractFunction)this.functionMap.put(token, (Object)function);
        if (oldFunction != null) {
            throw new Error("Duplicate token number.");
        }
    }

    public synchronized AbstractFunction remove(int token) {
        AbstractFunction function = (AbstractFunction)this.functionMap.remove(token);
        return function;
    }

    public synchronized void reinitAndMoveToRequestQueue(RequestQueue requestQueue) {
        TIntObjectIterator iterator = this.functionMap.iterator();
        TreeMap<Integer, AbstractFunction> functions = new TreeMap<Integer, AbstractFunction>();
        while (iterator.hasNext()) {
            iterator.advance();
            AbstractFunction function = (AbstractFunction)iterator.value();
            if (function == null) {
                throw new IllegalStateException("Null function in response queue.");
            }
            functions.put(function.getToken(), function);
        }
        this.functionMap.clear();
        for (AbstractFunction f : functions.values()) {
            f.prepareForSendingRequest(f.getReturnHandler());
            requestQueue.addLast(f);
        }
    }

    public synchronized AbstractFunction removeAny() {
        TIntObjectIterator iterator = this.functionMap.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        iterator.advance();
        AbstractFunction function = (AbstractFunction)iterator.value();
        if (function == null) {
            throw new IllegalStateException("Null function in response queue.");
        }
        this.functionMap.remove(function.getToken());
        return function;
    }
}

