/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procore.protocol.AAAFunction;
import org.simantics.db.procore.protocol.AbstractGraphClientEventHandler;
import org.simantics.db.procore.protocol.ExecuteFunction;
import org.simantics.db.procore.protocol.GraphClient;
import org.simantics.db.procore.protocol.NotConnectedException;
import org.simantics.db.procore.protocol.OpenClientSessionFunction;
import org.simantics.db.procore.protocol.ProtocolException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionManagerImpl;

public class ProCoreClient
extends AbstractGraphClientEventHandler {
    SessionManagerImpl sessionManagerImpl;
    GraphClient graphClient = null;
    final int sessionId = 0;
    int serverSessionId;
    int port = 0;
    boolean connected = false;

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect(int port) throws SessionException {
        if (this.connected) {
            throw new NotConnectedException("Illegal state. Already connected.");
        }
        if (port < 1) {
            throw new NotConnectedException("Illegal port=" + port);
        }
        if (this.sessionManagerImpl == null) {
            try {
                this.sessionManagerImpl = SessionManagerImpl.getInstance();
            }
            catch (IOException e) {
                String msg = "Could not create SessionManagerImpl.";
                Logger.defaultLogInfo((String)msg);
                throw new SessionException(msg, e);
            }
        }
        if (this.graphClient == null) {
            try {
                this.graphClient = this.sessionManagerImpl.newGraphClient(this);
                this.start(port);
                this.port = port;
                this.connected = true;
            }
            catch (Throwable t) {
                this.disconnect();
                throw new NotConnectedException("Could not connect.", t);
            }
        }
    }

    public void disconnect() {
        if (this.graphClient != null) {
            try {
                try {
                    this.graphClient.disconnect();
                }
                catch (Throwable t) {
                    Logger.defaultLogError((String)"Failed to disconnect from server.", (Throwable)t);
                    this.graphClient = null;
                    this.connected = false;
                }
            }
            finally {
                this.graphClient = null;
                this.connected = false;
            }
        }
    }

    public String execute(String command) throws SessionException {
        if (!this.connected) {
            throw new NotConnectedException("Illegal state. Not connected.");
        }
        ExecuteFunction t = new ExecuteFunction(command);
        try {
            this.graphClient.call(t, null);
        }
        catch (SessionException e) {
            this.disconnect();
            throw e;
        }
        if (t.out.endsWith("\n")) {
            return t.out.substring(0, t.out.length() - 1);
        }
        return t.out;
    }

    private void start(int port) throws Throwable {
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", port);
        this.graphClient.connect(address);
        AAAFunction af = new AAAFunction();
        this.graphClient.call(af, null);
        this.checkProtocol(af.args[0]);
        OpenClientSessionFunction ocs = new OpenClientSessionFunction();
        this.graphClient.call(ocs, null);
        this.serverSessionId = ocs.sessionId;
        Logger.defaultLogInfo((String)("Session id is " + this.serverSessionId));
        Logger.defaultLogInfo((String)("Head change set is " + ocs.headChangeSetId));
        this.connected = true;
    }

    private void checkProtocol(String protocolId) throws ProtocolException {
        String[] strings = protocolId.split("\\.");
        if (strings.length != 2) {
            throw new ProtocolException("Illegal protocolId=" + protocolId);
        }
        int major = Integer.parseInt(strings[0]);
        int minor = Integer.parseInt(strings[1]);
        if (major != 22) {
            throw new ProtocolException("Protocol major version mismatch: plugin=22 server=" + major);
        }
        if (minor < 0) {
            throw new ProtocolException("Protocol minor version mismatch: plugin=0 server=" + minor);
        }
    }
}

