/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.Value;

public class LongValue
extends Value {
    long[] values;

    public LongValue(long[] values) {
        this.values = values;
    }

    LongValue(int size, DataBuffer dataBuffer) {
        this.values = new long[size];
        int i = 0;
        while (i < size) {
            this.values[i] = dataBuffer.get(this.values[i]);
            ++i;
        }
    }

    public static long[] deserialize(int size, DataBuffer dataBuffer) {
        long[] values = new long[size];
        int i = 0;
        while (i < size) {
            values[i] = dataBuffer.get(values[i]);
            ++i;
        }
        return values;
    }

    @Override
    public void serialize(DataBuffer dataBuffer) {
        dataBuffer.put((byte)3);
        dataBuffer.put(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            dataBuffer.put(this.values[i]);
            ++i;
        }
    }

    public long[] getLong() {
        return this.values;
    }

    public void setLong(long[] a) {
        this.values = a;
    }

    public String toString() {
        return this.values.toString();
    }
}

