/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.Connector;
import org.simantics.db.procore.protocol.DebugPolicy;
import org.simantics.db.procore.protocol.NotConnectedException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionManagerImpl;

class IOEvents {
    private boolean data = false;
    private boolean request = false;
    private boolean stopping = false;
    private SessionException exception = null;
    private boolean connect = false;

    IOEvents() {
    }

    synchronized boolean hasEvents() {
        return this.data || this.request || this.stopping || this.exception != null;
    }

    synchronized boolean hasIEvents() {
        return this.data || this.stopping || this.exception != null;
    }

    synchronized boolean hasOEvents() {
        return this.request || this.stopping || this.exception != null;
    }

    synchronized void signalConnect(SessionException e) {
        this.exception = e;
        this.connect = true;
        this.notifyAll();
    }

    private boolean waitForConnectTest(SessionManagerImpl sessionManager, Connector connector) throws SessionException {
        if (this.connect) {
            return false;
        }
        if (this.exception != null) {
            throw new NotConnectedException("Connection failed.", (Throwable)((Object)this.exception));
        }
        boolean canHappen = sessionManager.isRegistered(connector);
        if (canHappen) {
            return true;
        }
        return !connector.getOnCalled();
    }

    synchronized void waitForConnect(SessionManagerImpl sessionManager, Connector connector) throws SessionException {
        long reportMs = DebugPolicy.LONG_EXECUTION_REPORT_PERIOD_UNIT.toMillis(10000L);
        long limitMs = reportMs * 10L;
        long totalMs = 0L;
        long elapsedMs = 0L;
        while (totalMs < limitMs && this.waitForConnectTest(sessionManager, connector)) {
            long start = System.currentTimeMillis();
            DebugPolicy.wait(reportMs, this, "IOEvents.waitForConnect");
            long end = System.currentTimeMillis();
            if (this.waitForConnectTest(sessionManager, connector)) {
                return;
            }
            long wait = end - start;
            totalMs += wait;
            if ((elapsedMs += wait) <= reportMs) continue;
            System.err.println("Wait for connection is taking long, so far " + totalMs + " ms. address=" + connector.getStringAddress());
            elapsedMs = 0L;
        }
        if (!this.connect) {
            throw new NotConnectedException("Connection failed.");
        }
    }

    synchronized void waitForIEvents() {
        while (!this.hasIEvents()) {
            DebugPolicy.wait(this, "IOEvents.waitForIEvents");
        }
    }

    synchronized void waitForOEvents() {
        while (!this.hasOEvents()) {
            DebugPolicy.wait(this, "IOEvents.waitForOEvents");
        }
    }

    synchronized boolean hasData() {
        return this.data;
    }

    synchronized void resetData() {
        this.data = false;
    }

    synchronized void signalData() {
        this.data = true;
        this.notifyAll();
    }

    synchronized boolean hasRequest() {
        return this.request;
    }

    synchronized void resetRequest() {
        this.request = false;
    }

    synchronized void signalRequest() {
        this.request = true;
        this.notifyAll();
    }

    synchronized boolean isOk() {
        return !this.isExcepted() && !this.isStopping();
    }

    synchronized boolean isExcepted() {
        return this.exception != null;
    }

    synchronized boolean isStopping() {
        return this.stopping;
    }

    synchronized void signalStopping() {
        this.stopping = true;
        this.notifyAll();
    }

    synchronized void signalStopping(SessionException e) {
        if (e != null) {
            this.exception = e;
        }
        this.stopping = true;
        this.notifyAll();
    }

    synchronized SessionException getException() {
        return this.exception;
    }

    synchronized void signalException(SessionException e) {
        this.exception = e;
        this.notifyAll();
    }
}

