/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteOrder;
import org.simantics.db.procore.protocol.AbstractFunction;
import org.simantics.db.procore.protocol.DataBuffer;

public class GetResourceSegmentFunction
extends AbstractFunction {
    public byte[] clusterUID = null;
    public int resourceIndex = 0;
    public long segmentOffset = 0L;
    public short segmentSize = 0;
    public boolean isExternalResource = false;
    public long valueSize = 0L;
    public byte[] segment = null;

    public GetResourceSegmentFunction() {
        super(31, 32);
    }

    public GetResourceSegmentFunction(byte[] clusterUID, int resourceIndex, long segmentOffset, short segmentSize) {
        super(31, 32);
        this.clusterUID = clusterUID;
        this.resourceIndex = resourceIndex;
        this.segmentOffset = segmentOffset;
        this.segmentSize = segmentSize;
    }

    @Override
    DataBuffer serialize(ByteOrder byteOrder) {
        this.buffer.clear();
        this.buffer.order(byteOrder);
        this.buffer.put(this.clusterUID);
        this.buffer.put(this.resourceIndex);
        this.buffer.put(this.segmentOffset);
        this.buffer.put(this.segmentSize);
        this.buffer.mark();
        return this.buffer;
    }

    @Override
    void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        this.receivedNumber = receivedNumber_;
        if (this.notRightDataForUs()) {
            return;
        }
        this.isExternalResource = dataBuffer.get(this.isExternalResource);
        this.valueSize = dataBuffer.get(this.valueSize);
        this.segment = dataBuffer.get(this.segment);
        this.gotResponse();
    }
}

