/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.Value;

public class FloatValue
extends Value {
    float[] values;

    public FloatValue(float[] values) {
        this.values = values;
    }

    FloatValue(int size, DataBuffer dataBuffer) {
        this.values = new float[size];
        int i = 0;
        while (i < size) {
            this.values[i] = dataBuffer.get(this.values[i]);
            ++i;
        }
    }

    public static float[] deserialize(int size, DataBuffer dataBuffer) {
        float[] values = new float[size];
        int i = 0;
        while (i < size) {
            values[i] = dataBuffer.get(values[i]);
            ++i;
        }
        return values;
    }

    @Override
    public void serialize(DataBuffer dataBuffer) {
        dataBuffer.put((byte)4);
        dataBuffer.put(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            dataBuffer.put(this.values[i]);
            ++i;
        }
    }

    public float[] getFloat() {
        return this.values;
    }

    public void setFloat(float[] a) {
        this.values = a;
    }

    public String toString() {
        return this.values.toString();
    }
}

