/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.Value;

public class DoubleValue
extends Value {
    double[] values;

    public DoubleValue(double[] values) {
        this.values = values;
    }

    DoubleValue(int size, DataBuffer dataBuffer) {
        this.values = new double[size];
        int i = 0;
        while (i < size) {
            this.values[i] = dataBuffer.get(this.values[i]);
            ++i;
        }
    }

    public static double[] deserialize(int size, DataBuffer dataBuffer) {
        double[] values = new double[size];
        int i = 0;
        while (i < size) {
            values[i] = dataBuffer.get(values[i]);
            ++i;
        }
        return values;
    }

    @Override
    public void serialize(DataBuffer dataBuffer) {
        dataBuffer.put((byte)5);
        dataBuffer.put(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            dataBuffer.put(this.values[i]);
            ++i;
        }
    }

    public double[] getDouble() {
        return this.values;
    }

    public void setDouble(double[] a) {
        this.values = a;
    }

    public String toString() {
        return this.values.toString();
    }
}

