/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.simantics.db.procore.protocol.ConnectionImpl;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionManagerImpl;

public class Connector {
    SocketChannel sc;
    ConnectionImpl connectionImpl;
    private final InetSocketAddress socketAddress;
    private boolean onCalled = false;
    SessionManagerImpl.Listener listener;

    Connector(ConnectionImpl connection, InetSocketAddress socketAddress) {
        this.connectionImpl = connection;
        this.socketAddress = socketAddress;
        this.listener = null;
    }

    InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    boolean getOnCalled() {
        return this.onCalled;
    }

    String getStringAddress() {
        if (this.socketAddress == null) {
            return "null";
        }
        return this.socketAddress.toString();
    }

    ConnectionImpl onConnect(SelectionKey sk, SessionManagerImpl.Listener shutdownListener) {
        this.listener = shutdownListener;
        this.connectionImpl.onConnectSucceeded(sk, shutdownListener);
        this.onCalled = true;
        return this.connectionImpl;
    }

    void onConnectFailed(SessionException exception) {
        this.onCalled = true;
        this.connectionImpl.onConnectFailed(exception);
    }
}

