/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procore.protocol.AbstractFunction;
import org.simantics.db.procore.protocol.AbstractMessage;
import org.simantics.db.procore.protocol.CallException;
import org.simantics.db.procore.protocol.Channel;
import org.simantics.db.procore.protocol.Compression;
import org.simantics.db.procore.protocol.CompressionException;
import org.simantics.db.procore.protocol.Connection;
import org.simantics.db.procore.protocol.Connector;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.EventException;
import org.simantics.db.procore.protocol.HeaderData;
import org.simantics.db.procore.protocol.IOEvents;
import org.simantics.db.procore.protocol.JournalException;
import org.simantics.db.procore.protocol.NotConnectedException;
import org.simantics.db.procore.protocol.ReceiveData;
import org.simantics.db.procore.protocol.RequestQueue;
import org.simantics.db.procore.protocol.ResponseQueue;
import org.simantics.db.procore.protocol.ReturnException;
import org.simantics.db.procore.protocol.ReturnHandler;
import org.simantics.db.procore.protocol.SendException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionManagerImpl;

class ConnectionImpl {
    private final boolean DEBUG = false;
    private final int DEFAULT_SIZE = 524288;
    private final int INCREMENT_SIZE = 8192;
    private static volatile int lastSentTokenNumber = 0;
    private ByteBuffer headerBuffer = null;
    private ByteBuffer buffer = null;
    private Compression compression = null;
    private HeaderData headerData = null;
    private ByteOrder byteOrder;
    private SessionManagerImpl sessionManager = null;
    private Channel channel = null;
    private RequestQueue requestQueue = null;
    ResponseQueue responseQueue = null;
    private IOEvents ioEvents = null;
    private ByteBuffer receiveBuffer;
    private long start = 0L;
    private long total = 0L;
    private long headerTotal = 0L;
    private long totalBytes = 0L;

    ConnectionImpl(SessionManagerImpl sessionManager) {
        this.sessionManager = sessionManager;
        this.channel = new Channel();
        this.ioEvents = new IOEvents();
    }

    ConnectionImpl(ConnectionImpl c) {
        this.sessionManager = c.sessionManager;
        this.channel = new Channel();
        this.ioEvents = new IOEvents();
    }

    synchronized void connect(SessionManagerImpl s, ByteOrder byteOrder) {
        this.headerBuffer = ByteBuffer.allocate(16);
        this.buffer = ByteBuffer.allocateDirect(524288);
        this.compression = new Compression();
        this.headerBuffer.order(byteOrder);
        this.buffer.order(byteOrder);
        this.headerData = new HeaderData();
        this.byteOrder = byteOrder;
        this.requestQueue = new RequestQueue();
        this.responseQueue = new ResponseQueue();
    }

    synchronized void send4Reconnect(ConnectionImpl aConnectionImpl) throws Throwable {
        if (aConnectionImpl != null && aConnectionImpl.requestQueue != null) {
            while (aConnectionImpl.requestQueue.size() > 0) {
                if (!this.isConnected()) {
                    throw new NotConnectedException("Connection lost during reconnect.");
                }
                AbstractFunction function = aConnectionImpl.requestQueue.removeFirst();
                function.prepareForSendingRequest(function.getReturnHandler());
                this.requestQueue.addFirst(function);
            }
        }
        this.ioEvents.signalRequest();
    }

    synchronized void disconnect() {
        AbstractFunction function;
        if (!this.isConnected()) {
            return;
        }
        this.channel.disconnect();
        this.headerBuffer = null;
        this.buffer = null;
        this.compression = null;
        this.headerData = null;
        this.sessionManager = null;
        while (this.requestQueue.size() > 0) {
            function = this.requestQueue.removeFirst();
            if (!function.hasResponse()) continue;
            function.setExceptionText("Closing connection (1).");
            function.gotResponse();
        }
        this.requestQueue = null;
        while (this.responseQueue.size() > 0) {
            function = this.responseQueue.removeAny();
            if (function == null) continue;
            function.setExceptionText("Closing connection (2).");
            function.gotResponse();
        }
        this.responseQueue = null;
    }

    synchronized ConnectionImpl disconnect4Reconnect() {
        ConnectionImpl newConnectionImpl = new ConnectionImpl(this);
        if (!this.isConnected()) {
            return newConnectionImpl;
        }
        this.channel.disconnect();
        this.headerBuffer = null;
        this.buffer = null;
        this.compression = null;
        this.headerData = null;
        this.sessionManager = null;
        while (this.responseQueue.size() > 0) {
            if (newConnectionImpl.requestQueue == null) {
                newConnectionImpl.requestQueue = new RequestQueue();
            }
            this.responseQueue.reinitAndMoveToRequestQueue(newConnectionImpl.requestQueue);
        }
        this.responseQueue = null;
        while (this.requestQueue.size() > 0) {
            if (newConnectionImpl.requestQueue == null) {
                newConnectionImpl.requestQueue = new RequestQueue();
            }
            AbstractFunction function = this.requestQueue.removeFirst();
            newConnectionImpl.requestQueue.addLast(function);
        }
        this.requestQueue = null;
        return newConnectionImpl;
    }

    private final ByteBuffer getReceiveBuffer(HeaderData header) {
        if (this.headerData.messageNumber == 28) {
            ByteBuffer buffer = ByteBuffer.allocate(this.headerData.deflateSize + 8192);
            buffer.order(this.byteOrder);
            return buffer;
        }
        if (this.buffer.capacity() < this.headerData.deflateSize) {
            this.buffer = ByteBuffer.allocate(this.headerData.deflateSize + 8192);
        }
        return this.buffer;
    }

    synchronized ReceiveData receiveDataInternal() throws IOException, NotConnectedException {
        if (this.headerBuffer == null) {
            return null;
        }
        if (this.headerBuffer.remaining() > 0) {
            long headerStart = System.nanoTime();
            int n = this.channel.socket().read(this.headerBuffer);
            long duration = System.nanoTime() - headerStart;
            this.headerTotal += duration;
            if (n < 0) {
                this.disconnect();
                throw new NotConnectedException("Failed to read header.");
            }
            if (n < 1) {
                return null;
            }
            if (this.headerBuffer.remaining() > 0) {
                return null;
            }
            this.headerBuffer.flip();
            this.headerData.token = this.headerBuffer.getInt();
            this.headerData.messageNumber = this.headerBuffer.getInt();
            this.headerData.inflateSize = this.headerBuffer.getInt();
            this.headerData.deflateSize = this.headerBuffer.getInt();
            this.receiveBuffer = this.getReceiveBuffer(this.headerData);
            this.receiveBuffer.clear();
            this.receiveBuffer.limit(this.headerData.deflateSize);
            if (this.headerData.deflateSize == 0) {
                this.headerBuffer.clear();
                return null;
            }
            if (this.headerData.messageNumber == 28) {
                this.start = System.nanoTime();
            }
        }
        if (this.receiveBuffer.remaining() > 0) {
            int n;
            int k = n = this.channel.socket().read(this.receiveBuffer);
            while (k > 0 && this.receiveBuffer.remaining() > 0) {
                this.channel.listenReadEvents();
                k = this.channel.socket().read(this.receiveBuffer);
                n += k;
            }
            if (n < 0) {
                throw new IOException("Failed to read data.");
            }
            if (n < 1) {
                return null;
            }
            if (this.receiveBuffer.remaining() > 0) {
                return null;
            }
            this.receiveBuffer.flip();
            if (this.headerData.messageNumber == 28) {
                long duration = System.nanoTime() - this.start;
                this.total += duration;
                this.totalBytes += (long)this.headerData.deflateSize;
            }
            try {
                ReceiveData receiveData = new ReceiveData(this.headerData);
                if (this.headerData.messageNumber != 28) {
                    receiveData.inflateBuffer = this.compression.inflate(this.headerData, this.buffer, this.byteOrder);
                } else {
                    receiveData.buffer = this.receiveBuffer;
                    receiveData.inflateSize = this.headerData.inflateSize;
                }
                ReceiveData receiveData2 = receiveData;
                return receiveData2;
            }
            catch (CompressionException e) {
                throw new IOException("Compression error.", (Throwable)((Object)e));
            }
            finally {
                this.headerBuffer.clear();
            }
        }
        return null;
    }

    void receive(Connection c) throws IOException, SessionException {
        this.receiveData(c);
        this.channel.listenReadEvents();
        this.receiveData(c);
    }

    private void receiveData(Connection c) throws IOException, SessionException {
        ReceiveData receiveData;
        while ((receiveData = this.receiveDataInternal()) != null) {
            c.handleInput(receiveData.token, receiveData.messageNumber, receiveData.inflateBuffer, receiveData);
        }
        return;
    }

    private void sendMessage(ByteBuffer byteBuffer) throws IOException, InterruptedException {
        int left = byteBuffer.remaining();
        while (left > 0) {
            ByteBuffer slice = byteBuffer.slice();
            int size = Math.min(left, 1000000);
            slice.limit(size);
            this.sendBuffer(slice);
            int position = byteBuffer.position() + size;
            byteBuffer.position(position);
            left -= size;
        }
    }

    private void sendBuffer(ByteBuffer byteBuffer) throws IOException, InterruptedException {
        int left = byteBuffer.remaining();
        while (left > 0) {
            int n = this.channel.socket().write(byteBuffer);
            if (n > 0) {
                left -= n;
                continue;
            }
            Thread.yield();
            if (left <= 0) continue;
            Logger.defaultLogTrace((String)("Could not send the whole byte buffer, left count = " + left + ", buffer remaining = " + byteBuffer.remaining() + ", write return =" + n));
        }
    }

    int wait4RequestsLess(int limit) {
        long start = 0L;
        boolean slept = false;
        int n;
        while ((n = this.requestQueue.size()) >= limit) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(int token, AbstractMessage message) throws IOException, InterruptedException {
        byte[] bytes = new byte[16];
        ByteBuffer header = ByteBuffer.wrap(bytes, 0, 16);
        header.order(this.byteOrder);
        header.putInt(token);
        int messageNumber = message.isEvent() ? message.responseNumber : message.requestNumber;
        header.putInt(messageNumber);
        header.putInt(0);
        DataBuffer t = message.serialize(this.byteOrder);
        ByteBuffer data = t.getByteBuffer();
        header.putInt(data.position());
        header.clear();
        Logger.defaultLogInfo((String)("Sending message, token=" + token + ", message=" + messageNumber));
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.sendMessage(header);
            data.limit(data.position());
            data.rewind();
            this.sendMessage(data);
        }
        Logger.defaultLogInfo((String)("Sent message, token=" + token + ", message=" + messageNumber));
    }

    synchronized void sendFunction(RequestQueue requestQueue, ResponseQueue responseQueue) throws SendException {
        if (requestQueue == null) {
            System.err.println("request queue is null");
            return;
        }
        if (responseQueue == null) {
            System.err.println("response queue is null");
            return;
        }
        AbstractFunction function = requestQueue.removeFirst();
        if (function == null) {
            System.err.println("function null");
            return;
        }
        int token = ++lastSentTokenNumber;
        try {
            this.sendMessage(token, function);
        }
        catch (IOException e) {
            requestQueue.addFirst(function);
            throw new SendException("Failed to send.", e);
        }
        catch (InterruptedException e) {
            requestQueue.addFirst(function);
            throw new SendException("Failed to send.", e);
        }
        function.setToken(token);
        if (function.hasResponse()) {
            responseQueue.add(function);
        }
    }

    void callFunction(AbstractFunction function, ReturnHandler returnHandler) throws CallException, JournalException {
        if (!this.isConnected()) {
            throw new NotConnectedException("Not connected.");
        }
        function.prepareForSendingRequest(returnHandler);
        this.requestQueue.addLast(function);
        this.ioEvents.signalRequest();
    }

    /*
     * Unable to fully structure code
     */
    void handleOEvents(Connection c) throws SendException {
        this.ioEvents.waitForOEvents();
        if (this.ioEvents.isOk()) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            if (this.requestQueue.size() > 0) {
                this.sendFunction(this.requestQueue, this.responseQueue);
            }
            this.ioEvents.resetRequest();
lbl7:
            // 2 sources

            ** while (this.ioEvents.hasRequest() || this.requestQueue.size() > 0)
        }
lbl8:
        // 1 sources

    }

    void handleIEvents(Connection c) throws SessionException, CallException, EventException, JournalException, ReturnException, NotConnectedException, IOException {
        this.ioEvents.waitForIEvents();
        if (this.ioEvents.isStopping()) {
            return;
        }
        SessionException e = this.ioEvents.getException();
        if (e != null) {
            throw e;
        }
        if (this.ioEvents.hasData()) {
            this.ioEvents.resetData();
            this.receive(c);
        }
    }

    void waitConnect(Connector connector) throws SessionException {
        this.ioEvents.waitForConnect(this.sessionManager, connector);
        if (this.ioEvents.getException() != null || !this.isConnected() || this.isStopping()) {
            if (this.ioEvents.getException() != null) {
                throw this.ioEvents.getException();
            }
            throw new NotConnectedException("Connection failed.");
        }
    }

    void onRead() throws IOException {
        this.ioEvents.signalData();
    }

    void onReadFailed(SessionException exception) {
        this.ioEvents.signalStopping(exception);
    }

    void onConnectFailed(SessionException exception) {
        this.ioEvents.signalConnect(exception);
    }

    void onConnectSucceeded(SelectionKey key, SessionManagerImpl.Listener shutdownListener) {
        try {
            this.channel.connect(key);
            this.connect(this.sessionManager, ByteOrder.LITTLE_ENDIAN);
            this.ioEvents.signalConnect(null);
        }
        catch (Throwable t) {
            this.ioEvents.signalConnect(new NotConnectedException("Failed to finalize connection.", t));
        }
    }

    void onDisconnect() {
        this.disconnect();
    }

    boolean isConnected() {
        boolean ret = this.channel.isConnected() && this.responseQueue != null && this.requestQueue != null;
        return ret;
    }

    boolean isStopping() {
        return this.ioEvents.isStopping();
    }

    boolean isOk() {
        return this.isConnected() && !this.isStopping() && !this.ioEvents.isExcepted();
    }

    void signalException(SessionException e) {
        this.ioEvents.signalException(e);
    }

    void signalMessage() {
        this.ioEvents.signalData();
    }

    void signalStopping() {
        this.ioEvents.signalStopping();
    }
}

