/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.simantics.db.common.SessionThreads;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procore.protocol.AAAFunction;
import org.simantics.db.procore.protocol.AbstractEvent;
import org.simantics.db.procore.protocol.AbstractFunction;
import org.simantics.db.procore.protocol.AbstractMessage;
import org.simantics.db.procore.protocol.CallException;
import org.simantics.db.procore.protocol.ConnectionImpl;
import org.simantics.db.procore.protocol.Connector;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.DebugPolicy;
import org.simantics.db.procore.protocol.EventException;
import org.simantics.db.procore.protocol.GraphClientImpl;
import org.simantics.db.procore.protocol.JournalException;
import org.simantics.db.procore.protocol.NotConnectedException;
import org.simantics.db.procore.protocol.OpenClientSessionFunction;
import org.simantics.db.procore.protocol.OutputEndException;
import org.simantics.db.procore.protocol.ReceiveData;
import org.simantics.db.procore.protocol.ReconnectHandler;
import org.simantics.db.procore.protocol.ReturnException;
import org.simantics.db.procore.protocol.ReturnHandler;
import org.simantics.db.procore.protocol.SendException;
import org.simantics.db.procore.protocol.SessionException;
import org.simantics.db.procore.protocol.SessionIOException;
import org.simantics.db.procore.protocol.SessionManagerImpl;

public abstract class Connection
extends Thread {
    private final boolean DEBUG = false;
    public static final ThreadGroup ConnectionThreadGroup = new ThreadGroup("Connection Thread Group");
    private static volatile int instanceCount;
    protected final SessionManagerImpl sessionManager;
    private ConnectionImpl connectionImpl = null;
    private Connector connector = null;
    private InetSocketAddress inetSocketAddress = null;
    private Thread outputThread = null;
    private final ReconnectHandler reconnectHandler = new ReconnectHandler();

    protected abstract void handleInput(int var1, int var2, DataBuffer var3, ReceiveData var4) throws SessionException;

    public Connection(SessionManagerImpl sessionManager) {
        super(ConnectionThreadGroup, "Connection " + ++instanceCount);
        this.sessionManager = sessionManager;
        Logger.defaultLogTrace((String)"Connection");
    }

    private void checkConnection() throws SessionException {
        if (this.inetSocketAddress == null) {
            throw new NotConnectedException("Connetion has not been established.");
        }
    }

    protected synchronized void signalMessage() throws SessionException {
        this.checkConnection();
        this.connectionImpl.signalMessage();
    }

    protected AbstractFunction getFunctionByToken(int token) throws SessionException {
        this.checkConnection();
        return this.connectionImpl.responseQueue.remove(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendMessage(int token, AbstractMessage message) throws SessionException {
        ReconnectHandler reconnectHandler = this.reconnectHandler;
        synchronized (reconnectHandler) {
            this.checkConnection();
            try {
                this.connectionImpl.sendMessage(token, message);
            }
            catch (IOException e) {
                throw new SessionIOException("Failed to send message. token=" + token, e);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((String)"Send message was interrupted.", (Throwable)e);
            }
        }
    }

    private boolean wait4ResponseTest(AbstractFunction function) {
        if (!function.hasResponsePending()) {
            return false;
        }
        if (SessionThreads.isClosed()) {
            return false;
        }
        return this.isConnected();
    }

    private boolean isServerAlive() throws SessionException {
        long running;
        long current = Thread.currentThread().getId();
        if (current == (running = this.getId())) {
            return false;
        }
        AAAFunction function = new AAAFunction();
        this.connectionImpl.callFunction(function, null);
        function.waitForResponse(this, 10000L);
        if (function.hasResponsePending()) {
            return false;
        }
        return !function.hasException();
    }

    private void wait4Response(AbstractFunction function) throws SessionException {
        long reportMs = DebugPolicy.LONG_EXECUTION_REPORT_PERIOD_UNIT.toMillis(10000L);
        long totalMs = 0L;
        long count = 0L;
        while (this.wait4ResponseTest(function)) {
            long start = System.currentTimeMillis();
            function.waitForResponse(this, 10000L);
            long end = System.currentTimeMillis();
            if (!this.wait4ResponseTest(function)) break;
            long elapsed = end - start;
            if ((totalMs += elapsed) < reportMs) continue;
            System.err.println("DB server function '" + function.getClass().getSimpleName() + "' is taking long to execute/respond, so far " + totalMs + " ms. (token=" + function.getToken() + ", returnHandler=" + function.getReturnHandler() + ")");
            if (!function.hasResponsePending() || ++count <= 10L) continue;
            if (!this.isServerAlive()) {
                throw new CallException("Connection to server lost in the middle of a call. token=" + function.getToken());
            }
            count = 0L;
        }
        if (function.hasResponsePending()) {
            Logger.defaultLogInfo((String)function.getExceptionText());
            throw new CallException("Remote function call response lost. token=" + function.getToken());
        }
        if (function.hasException()) {
            Logger.defaultLogInfo((String)function.getExceptionText());
            throw new CallException("Remote function call exception: " + function.getExceptionText() + " token=" + function.getToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void callImpl(AbstractFunction function, ReturnHandler returnHandler) throws SessionException {
        ReconnectHandler reconnectHandler = this.reconnectHandler;
        synchronized (reconnectHandler) {
            this.connectionImpl.callFunction(function, returnHandler);
            if (returnHandler != null) {
                return;
            }
            this.wait4Response(function);
            return;
        }
    }

    public synchronized void connect(InetSocketAddress sa) throws SessionException {
        if (this.inetSocketAddress != null) {
            throw new IllegalStateException("Calling connect more than once is not supported.");
        }
        this.connectionRegister(sa);
        this.inetSocketAddress = sa;
        this.start();
    }

    private void stopIOThreads() {
        this.connectionImpl.signalStopping();
        this.interrupt();
        while (this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Logger.defaultLogError((String)"Sleep interrupted while waiting for connecion threads to stop.", (Throwable)e1);
                }
            }
        }
    }

    public synchronized void disconnect() throws SessionException {
        if (this.inetSocketAddress == null) {
            return;
        }
        this.stopIOThreads();
        this.connectionImpl.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (this.inetSocketAddress == null) {
            return false;
        }
        ReconnectHandler reconnectHandler = this.reconnectHandler;
        synchronized (reconnectHandler) {
            return this.connectionImpl.isConnected();
        }
    }

    public void sendMessage(AbstractEvent event) throws SessionException {
        this.sendMessage(event.getToken(), event);
    }

    public synchronized int wait4RequestsLess(int limit) throws SessionException {
        this.checkConnection();
        return this.connectionImpl.wait4RequestsLess(limit);
    }

    private void connectionRegister(InetSocketAddress sa) throws SessionException {
        ConnectionImpl aConnectionImpl = new ConnectionImpl(this.sessionManager);
        Connector aConnector = new Connector(aConnectionImpl, sa);
        this.sessionManager.register(aConnector);
        aConnectionImpl.waitConnect(aConnector);
        this.connector = aConnector;
        this.connectionImpl = aConnectionImpl;
    }

    private boolean reconnectConnect(Local local, ConnectionImpl aConnectionImpl) {
        try {
            this.connectionRegister(this.inetSocketAddress);
            this.connectionImpl.callFunction(new OpenClientSessionFunction(), this.reconnectHandler);
            this.connectionImpl.send4Reconnect(aConnectionImpl);
            this.startOutput(local);
            return true;
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("Connection.reconnectConnect caught an exception: " + t.getMessage()), (Throwable)t);
            return false;
        }
        finally {
            aConnectionImpl.disconnect();
        }
    }

    private ConnectionImpl reconnectDisconnect(Throwable cause, Output output) {
        try {
            ConnectionImpl newConnectionImpl = this.connectionImpl.disconnect4Reconnect();
            return newConnectionImpl;
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("Connection.reconnectDisconnect caught an exception: " + t.getMessage()), (Throwable)t);
            return null;
        }
    }

    private boolean reconnectCloseOutput(Throwable cause, Output output) {
        try {
            if (cause != null) {
                Logger.defaultLogError((Throwable)cause);
            }
            this.stopOutput();
            Throwable outputCause = output.getThrowable();
            if (outputCause != null) {
                Logger.defaultLogError((String)("Output thread did not die cleanly: " + outputCause.getMessage()), (Throwable)outputCause);
            }
            return true;
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("Connection.reconnectCloseOutput caught an exception: " + t.getMessage()), (Throwable)t);
            return false;
        }
    }

    private void outputBegin() {
    }

    private boolean outputOk() {
        return this.connectionImpl.isConnected() && !this.connectionImpl.isStopping();
    }

    private void outputDo() throws SendException {
        this.connectionImpl.handleOEvents(this);
    }

    private void outputEnd() {
        this.connectionImpl.signalException(new OutputEndException("End of output thread."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runReconnect(Local local, Throwable t) {
        local.cause = t;
        ReconnectHandler reconnectHandler = this.reconnectHandler;
        synchronized (reconnectHandler) {
            if (this.connectionImpl.isStopping()) {
                local.cause = null;
                return false;
            }
            if (!this.reconnectCloseOutput(local.cause, local.output)) {
                return false;
            }
            ConnectionImpl connectionImpl = this.reconnectDisconnect(t, local.output);
            if (connectionImpl == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= 10) {
                    return false;
                }
                Logger.defaultLogError((String)("Connection.reconnect try " + i));
                if (this.reconnectConnect(local, connectionImpl)) {
                    local.cause = null;
                    return true;
                }
                if (!this.reconnectCloseOutput(local.cause, local.output)) {
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Logger.defaultLogError((String)"Connection.reconnectConnect sleep interrupted.");
                }
                ++i;
            }
        }
    }

    private void runException(Local local, DatabaseException e) {
        Logger.defaultLogError((String)("Journal exception: " + e.getMessage()));
        if (this.connector != null && this.connector.listener != null) {
            this.connector.listener.exception((GraphClientImpl)this, (Throwable)e);
        }
        local.cause = e;
    }

    private void startOutput(Local local) throws SessionException {
        if (this.outputThread != null && this.outputThread.isAlive()) {
            throw new SessionException("Output thread must be dead before starting it.");
        }
        local.output = new Output();
        this.outputThread = new Thread(ConnectionThreadGroup, local.output, String.valueOf(this.getName()) + " Output");
        this.outputThread.start();
        while (!local.output.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.defaultLogInfo((String)"Thread interrupted");
                if (this.outputThread.isAlive()) continue;
                throw new NotConnectedException("Could not start output thread.");
            }
        }
    }

    private void stopOutput() {
        this.connectionImpl.signalStopping();
        this.outputThread.interrupt();
        while (this.outputThread.isAlive()) {
            try {
                this.outputThread.join();
            }
            catch (InterruptedException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        local = new Local();
        try {
            this.startOutput(local);
            if (true) ** GOTO lbl37
        }
        catch (SessionException e) {
            Logger.defaultLogError((String)("Output thread did not start cleanly: " + e.getMessage()), (Throwable)e);
            return;
        }
        do {
            try {
                this.connectionImpl.handleIEvents(this);
            }
            catch (OutputEndException e) {
                if (!Connection.$assertionsDisabled && this.outputThread.isAlive()) {
                    throw new AssertionError();
                }
                local.cause = local.output.getThrowable();
                if (local.cause != null) break;
                if (!this.runReconnect(local, (Throwable)e)) continue;
            }
            catch (JournalException e) {
                this.runException(local, (DatabaseException)e);
                break;
            }
            catch (EventException e) {
                this.runException(local, (DatabaseException)e);
                break;
            }
            catch (ReturnException e) {
                this.runException(local, (DatabaseException)e);
                break;
            }
            catch (SessionException e) {
                if (!this.runReconnect(local, (Throwable)e)) break;
            }
            catch (IOException e) {
                if (!this.runReconnect(local, e)) break;
            }
            catch (Throwable e) {
                local.cause = e;
                break;
            }
lbl37:
            // 6 sources

        } while (!this.connectionImpl.isStopping());
        if (local.cause != null) {
            Logger.defaultLogError((Throwable)local.cause);
        }
        if (this.connector != null && this.connector.listener != null) {
            this.connector.listener.shutdown((GraphClientImpl)this, local.cause);
        }
        this.connectionImpl.disconnect();
        this.stopOutput();
        outputCause = local.output.getThrowable();
        if (outputCause != null) {
            Logger.defaultLogError((String)("Output thread did not die cleanly: " + outputCause.getMessage()), (Throwable)outputCause);
        }
    }

    static class Local {
        public Throwable cause = null;
        public Output output = null;

        Local() {
        }
    }

    class Output
    implements Runnable {
        private boolean started = false;
        private boolean stopped = false;
        private Throwable throwable = null;

        Output() {
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        boolean isStarted() {
            return this.started;
        }

        boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            this.started = true;
            try {
                Connection.this.outputBegin();
                while (Connection.this.outputOk()) {
                    try {
                        Connection.this.outputDo();
                    }
                    catch (Throwable t) {
                        this.throwable = t;
                        break;
                    }
                }
            }
            finally {
                this.stopped = true;
                Connection.this.outputEnd();
                Logger.defaultLogInfo((String)"Connection output end");
            }
        }
    }
}

