/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.simantics.db.procore.protocol.AbstractCompression;
import org.simantics.db.procore.protocol.CompressionException;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.HeaderData;
import org.simantics.fastlz.FastLZ;

public class Compression
extends AbstractCompression {
    private byte[] data = new byte[0];
    private final int INCREMENT_SIZE = 8192;
    private byte[] hack = new byte[8192];
    private int inSize = 0;
    private int outSize = 0;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;

    private void ensureIn(int size) {
        if (size > this.inSize) {
            this.inBuffer = ByteBuffer.allocateDirect(size);
            this.inSize = size;
        }
    }

    private void ensureOut(int size) {
        if (size > this.outSize) {
            this.outBuffer = ByteBuffer.allocateDirect(size);
            this.outSize = size;
        }
    }

    private synchronized byte[] inflate(byte[] in, int length, int size) throws CompressionException {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
        this.ensureIn(length);
        this.ensureOut(size);
        this.inBuffer.rewind();
        this.outBuffer.rewind();
        this.inBuffer.put(in, 0, length);
        this.inBuffer.flip();
        int inflateSize = FastLZ.decompressBuffer((ByteBuffer)this.inBuffer, (int)0, (int)length, (ByteBuffer)this.outBuffer, (int)0, (int)size);
        if (inflateSize != size) {
            throw new RuntimeException("Decompression error, inflate size=" + inflateSize + "expected size=" + size);
        }
        this.outBuffer.get(this.data, 0, size);
        return this.data;
    }

    public synchronized DataBuffer inflate(HeaderData headerData, ByteBuffer buffer, ByteOrder byteOrder) throws CompressionException {
        DataBuffer inflateBuffer = null;
        if (headerData.inflateSize == 0) {
            inflateBuffer = new DataBuffer(buffer);
            inflateBuffer.order(byteOrder);
            return inflateBuffer;
        }
        if (this.hack.length < headerData.deflateSize) {
            this.hack = new byte[headerData.deflateSize + 8192];
        }
        buffer.get(this.hack, 0, headerData.deflateSize);
        byte[] data = this.inflate(this.hack, headerData.deflateSize, headerData.inflateSize);
        inflateBuffer = new DataBuffer(data);
        inflateBuffer.order(byteOrder);
        return inflateBuffer;
    }
}

