/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.simantics.db.procore.protocol.CompressionException;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.FastLZJava;

public class ClusterDecompressor {
    private byte[] inflateBuffer;

    public Object[] inflateCluster(int inflateSize, ByteBuffer deflatedCluster) throws CompressionException {
        Object[] arrays;
        int deflatedSize = deflatedCluster.limit();
        int inflated = this.decompressCluster(deflatedCluster, deflatedSize, inflateSize, arrays = new Object[3]);
        if (inflated != inflateSize) {
            throw new CompressionException("decompression error, inflated " + inflated + " bytes when " + inflateSize + " expected.");
        }
        return arrays;
    }

    public int decompressCluster(ByteBuffer deflated, int deflatedSize, int inflatedSize, Object[] arrays) {
        if (deflated.isDirect() && FastLZ.isNativeInitialized()) {
            FastLZ.decompressCluster((ByteBuffer)deflated, (int)deflatedSize, (int)inflatedSize, (Object[])arrays);
            return inflatedSize;
        }
        byte[] array = null;
        if (deflated.hasArray()) {
            array = deflated.array();
        } else {
            array = new byte[deflatedSize];
            int pos = deflated.position();
            deflated.position(0);
            deflated.get(array, 0, deflatedSize);
            deflated.position(pos);
        }
        return this.decompressCluster(array, deflatedSize, inflatedSize, arrays);
    }

    public synchronized int decompressCluster(byte[] deflated, int deflatedSize, int inflatedSize, Object[] arrays) {
        if (this.inflateBuffer == null) {
            this.inflateBuffer = new byte[inflatedSize];
        } else if (this.inflateBuffer.length < inflatedSize) {
            this.inflateBuffer = new byte[inflatedSize];
        }
        return ClusterDecompressor.decompressCluster(deflated, deflatedSize, this.inflateBuffer, inflatedSize, arrays);
    }

    public static int decompressCluster(byte[] deflated, int deflatedSize, byte[] inflated, int inflatedSize, Object[] arrays) {
        if (inflated.length < inflatedSize) {
            throw new IllegalArgumentException("inflate buffer size (" + inflated.length + ") is smaller than inflated size (" + inflatedSize + ")");
        }
        int decompressedBytes = FastLZJava.decompress((byte[])deflated, (int)0, (int)deflatedSize, (byte[])inflated, (int)0, (int)inflatedSize);
        if (decompressedBytes != inflatedSize) {
            return decompressedBytes;
        }
        int offset = 0;
        int longCount = ClusterDecompressor.readInt(inflated, offset);
        long[] longs = new long[longCount];
        ClusterDecompressor.copyLongs(inflated, offset + 4, longs);
        int intCount = ClusterDecompressor.readInt(inflated, offset += 4 + 8 * longCount);
        int[] ints = new int[intCount];
        ClusterDecompressor.copyInts(inflated, offset + 4, ints);
        int byteCount = ClusterDecompressor.readInt(inflated, offset += 4 + 4 * intCount);
        byte[] bytes = Arrays.copyOfRange(inflated, offset + 4, offset + 4 + byteCount);
        arrays[0] = longs;
        arrays[1] = ints;
        arrays[2] = bytes;
        return decompressedBytes;
    }

    private static void copyInts(byte[] bytes, int i, int[] ints) {
        int offset = i;
        int count = ints.length;
        int a = 0;
        while (a < count) {
            int value;
            ints[a] = value = bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
            ++a;
            offset += 4;
        }
    }

    private static void copyLongs(byte[] bytes, int i, long[] longs) {
        int offset = i;
        int count = longs.length;
        int a = 0;
        while (a < count) {
            long value;
            longs[a] = value = (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
            ++a;
            offset += 8;
        }
    }

    private static int readInt(byte[] array, int offset) {
        return array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
    }
}

