/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

class Channel {
    private SelectionKey selectionKey = null;
    private SocketChannel socketChannel = null;

    Channel() {
    }

    synchronized void connect(SelectionKey key) {
        this.selectionKey = key;
        this.socketChannel = (SocketChannel)key.channel();
    }

    synchronized void disconnect() {
        if (this.selectionKey == null) {
            return;
        }
        try {
            try {
                this.selectionKey.interestOps(0);
                this.selectionKey.cancel();
                this.selectionKey.selector().wakeup();
            }
            catch (CancelledKeyException cancelledKeyException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.socketChannel.socket().close();
            }
            catch (IOException iOException) {}
        }
        finally {
            this.selectionKey = null;
            this.socketChannel = null;
        }
    }

    synchronized boolean isConnected() {
        boolean ret = this.selectionKey != null && this.socketChannel.isConnected();
        return ret;
    }

    synchronized SocketChannel socket() {
        return this.socketChannel;
    }

    synchronized void listenReadEvents() throws IOException {
        if (this.selectionKey == null) {
            throw new IOException("Trying to listen connection which is not connected.");
        }
        int ops = this.selectionKey.interestOps() | 1;
        this.selectionKey.interestOps(ops);
        this.selectionKey.selector().wakeup();
    }
}

