/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.Message;

public abstract class AbstractMessage
extends Message {
    protected final int requestNumber;
    protected final int responseNumber;
    protected int receivedNumber = 0;
    protected boolean responsePending = false;
    protected DataBuffer buffer;
    private String exceptionText = null;

    AbstractMessage(int requestNumber, int responseNumber) {
        this.requestNumber = requestNumber;
        this.responseNumber = responseNumber;
        this.buffer = new DataBuffer(DataBuffer.Allocation.DirectAllocation);
    }

    AbstractMessage(int requestNumber, int responseNumber, DataBuffer buffer) {
        this.requestNumber = requestNumber;
        this.responseNumber = responseNumber;
        this.buffer = buffer;
    }

    @Override
    boolean hasResponse() {
        return this.responseNumber != 0;
    }

    @Override
    String getExceptionText() {
        return this.exceptionText;
    }

    @Override
    void setExceptionText(String text) {
        this.exceptionText = text;
    }

    void gotResponse() {
        this.responsePending = false;
    }
}

