/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.protocol;

import org.simantics.db.procore.protocol.AbstractMessage;
import org.simantics.db.procore.protocol.Connection;
import org.simantics.db.procore.protocol.DataBuffer;
import org.simantics.db.procore.protocol.DebugPolicy;
import org.simantics.db.procore.protocol.ReturnHandler;
import org.simantics.db.procore.protocol.SessionException;

public abstract class AbstractFunction
extends AbstractMessage {
    private ReturnHandler returnHandler = null;
    private int token = 0;

    void setToken(int token) {
        this.token = token;
    }

    int getToken() {
        return this.token;
    }

    AbstractFunction(int requestNumber, int responseNumber) {
        super(requestNumber, responseNumber);
    }

    AbstractFunction(int requestNumber, int responseNumber, DataBuffer buffer) {
        super(requestNumber, responseNumber, buffer);
    }

    @Override
    boolean isEvent() {
        return false;
    }

    @Override
    String getExceptionText() {
        String t = super.getExceptionText();
        if (t != null) {
            return super.getExceptionText();
        }
        if (this.notRightDataForUs()) {
            return "Response type does not match.";
        }
        return null;
    }

    ReturnHandler getReturnHandler() {
        return this.returnHandler;
    }

    public boolean hasException() {
        return this.notRightDataForUs() || super.getExceptionText() != null;
    }

    boolean notRightDataForUs() {
        return this.receivedNumber != this.responseNumber;
    }

    void prepareForSendingRequest(ReturnHandler returnHandler) {
        this.receivedNumber = 0;
        this.responsePending = true;
        super.setExceptionText(null);
        this.returnHandler = returnHandler;
    }

    boolean hasResponsePending() {
        return this.hasResponse() && this.responsePending;
    }

    @Override
    synchronized void gotResponse() {
        this.responsePending = false;
        this.notify();
    }

    synchronized void waitForResponse(Connection connection, long waitMs) throws SessionException {
        String string = "AbstractFunction.waitForResponse";
        DebugPolicy.wait(waitMs, this, string);
    }
}

