/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.platform.VariablePrefix;
import org.simantics.browsing.ui.platform.VariablesInput;
import org.simantics.browsing.ui.swt.IVariablesPage;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class VariablesPage
extends Page
implements IPageBookViewPage,
IVariablesPage {
    protected static final int MAX_SELECTION_LENGTH_TO_SHOW = 5;
    protected ISessionContext sessionContext;
    protected GraphExplorerComposite explorer;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            VariablesPage.this.setSessionContext(event.getNewValue());
        }
    };
    PartNameListener currentPartNameListener = null;
    private PartListener partListener = new PartListener();
    protected IWorkbenchPartSite site;
    private IWorkbenchPart sourcePart;
    protected IAdaptable adapter;

    public VariablesPage(IWorkbenchPartSite site) {
        this.site = site;
    }

    public VariablesPage(IWorkbenchPartSite site, IAdaptable adapter) {
        this(site);
        this.setAdapter(adapter);
    }

    public void dispose() {
        if (this.currentPartNameListener != null) {
            this.currentPartNameListener.dispose();
        }
        if (this.adapter != null) {
            ISessionContextProvider contextProvider = this.getSessionContextProvider();
            contextProvider.removeContextChangedListener(this.contextChangeListener);
        }
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
            this.sourcePart = null;
        }
        this.site = null;
        this.adapter = null;
        this.explorer = null;
        this.sessionContext = null;
    }

    protected ISessionContextProvider getSessionContextProvider() {
        return (ISessionContextProvider)this.getAdapter().getAdapter(ISessionContextProvider.class);
    }

    protected ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public final void createControl(Composite parent) {
        this.createPageControls(parent);
        ISessionContextProvider contextProvider = this.getSessionContextProvider();
        contextProvider.addContextChangedListener(this.contextChangeListener);
        this.setSessionContext(contextProvider.getSessionContext());
    }

    protected void createPageControls(Composite parent) {
        HashMap args = new HashMap();
        HashSet<String> browseContexts = new HashSet<String>();
        browseContexts.add("org.simantics.browsing.ui.graph.variablesView");
        args.put("browseContexts", browseContexts);
        this.explorer = new GraphExplorerComposite(args, (IWorkbenchSite)this.site, parent, 0);
        this.explorer.setInputSource(new GraphExplorerComposite.InputSource(){

            public Object get(ISessionContext ctx, Object selection) {
                Resource input = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
                if (input == null) {
                    return GraphExplorer.EMPTY_INPUT;
                }
                VariablePrefix prefix = (VariablePrefix)AdaptionUtils.adaptToSingle((Object)selection, VariablePrefix.class);
                if (prefix == null) {
                    return new VariablesInput(null, input);
                }
                return new VariablesInput(prefix.getPrefix(), input);
            }
        });
    }

    protected final void setSessionContext(ISessionContext newContext) {
        ISessionContext oldContext = this.sessionContext;
        this.sessionContext = newContext;
        this.sessionContextChanged(oldContext, newContext);
    }

    protected void sessionContextChanged(ISessionContext oldContext, ISessionContext newContext) {
        this.explorer.applySessionContext(newContext);
    }

    public Control getControl() {
        return this.explorer != null ? this.explorer : null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setFocus() {
    }

    protected void sourcePartClosed(IWorkbenchPart part) {
    }

    protected void sourceSelectionChanged(ISelection selection) {
        if (!this.explorer.isDisposed()) {
            this.explorer.setInput((Object)selection, false);
        }
    }

    public void updatePartName(final ISelection forSelection, Callback<String> updateCallback) {
        PartNameListener oldListener = this.currentPartNameListener;
        PartNameListener newListener = new PartNameListener(updateCallback);
        if (oldListener != null) {
            oldListener.dispose();
        }
        if (this.sessionContext != null) {
            this.sessionContext.getSession().asyncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return VariablesPage.this.computeTitle(graph, forSelection);
                }
            }, (Listener)newListener);
        }
    }

    protected static String safeGetName(ReadGraph g, Resource r) throws DatabaseException {
        try {
            return (String)g.adapt(r, String.class);
        }
        catch (AdaptionException e) {
            return NameUtils.getSafeName((ReadGraph)g, (Resource)r);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String computeTitle(ReadGraph graph, ISelection selection) throws DatabaseException {
        boolean sameTypes = true;
        try {
            ResourceArray[] ras = ResourceAdaptionUtils.toResourceArrays((Object)selection);
            if (ras.length == 0) {
                return null;
            }
            Collection types = null;
            ResourceArray[] resourceArrayArray = ras;
            int n = ras.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceArray ra = resourceArrayArray[n2];
                if (ra.isEmpty()) {
                    return null;
                }
                if (types == null) {
                    types = graph.getPrincipalTypes(ra.resources[0]);
                } else {
                    Collection ts = graph.getPrincipalTypes(ra.resources[0]);
                    ts.removeAll(types);
                    if (!ts.isEmpty()) {
                        sameTypes = false;
                        break;
                    }
                }
                ++n2;
            }
            if (sameTypes) {
                if (!graph.hasStatement(ras[0].resources[0])) {
                    return null;
                }
                String name = VariablesPage.safeGetName(graph, ras[0].resources[0]);
                if (ras.length <= 1) return name;
                return String.valueOf(name) + " [" + ras.length + "]";
            }
            ArrayList<String> names = new ArrayList<String>(ras.length);
            boolean truncate = ras.length > 5;
            int end = Math.min(ras.length, 5);
            int missing = ras.length - end;
            int i = 0;
            while (true) {
                if (i >= end) {
                    if (!names.isEmpty()) break;
                    return null;
                }
                if (graph.hasStatement(ras[i].resources[0])) {
                    names.add(VariablesPage.safeGetName(graph, ras[i].resources[0]));
                }
                ++i;
            }
            if (!truncate) return ((Object)names).toString();
            names.add("+ " + missing + " more...");
            return ((Object)names).toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void setAdapter(IAdaptable adapter) {
        assert (adapter != null);
        this.adapter = adapter;
    }

    public IAdaptable getAdapter() {
        assert (this.adapter != null);
        return this.adapter;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getControl() == null) {
            return;
        }
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
            this.sourcePart = null;
        }
        this.sourceSelectionChanged(selection);
        this.sourcePart = part;
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().addPartListener((IPartListener)this.partListener);
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (VariablesPage.this.sourcePart == part) {
                VariablesPage.this.sourcePart = null;
                VariablesPage.this.sourcePartClosed(part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    static class PartNameListener
    implements Listener<String> {
        private boolean disposed = false;
        private final Callback<String> updateCallback;

        public PartNameListener(Callback<String> updateCallback) {
            assert (updateCallback != null);
            this.updateCallback = updateCallback;
        }

        public void dispose() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void execute(String result) {
            this.updateCallback.run((Object)result);
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }
    }
}

