/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.platform;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.views.swt.ModelledView;

public class DescriptionView
extends ModelledView {
    protected String configurationURI() {
        return "http://www.simantics.org/Browsing-1.1/DescriptionView";
    }

    protected void inputChanged(IWorkbenchPart part, Object input) {
        this.updateViewDescription(input);
        super.inputChanged(part, input);
    }

    private void updateViewDescription(Object input) {
        if (input instanceof Resource) {
            Resource r = (Resource)input;
            ISessionContext ctx = this.getSessionContext();
            if (ctx != null) {
                try {
                    String desc = (String)ctx.getSession().syncRequest((Read)new ResourceRead<String>(r){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            return this.formName(graph, this.resource);
                        }

                        private String formName(ReadGraph graph, Resource r) throws DatabaseException {
                            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                            Resource project = Simantics.getProjectResource();
                            String projectUri = project != null ? graph.getPossibleURI(project) : "";
                            String uri = graph.getPossibleURI(r);
                            if (uri != null && uri.startsWith(projectUri)) {
                                uri = uri.substring(projectUri.length());
                            }
                            return uri != null ? String.valueOf(name) + " (" + uri + ")" : name;
                        }
                    });
                    this.setContentDescription(desc);
                }
                catch (DatabaseException e) {
                    this.setContentDescription(e.getMessage());
                }
            }
        } else {
            this.setContentDescription("");
        }
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }
}

