/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.wizard;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ui.wizard.ExportPlan;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class DrawingTemplateExportPage
extends WizardPage {
    ExportPlan exportModel;
    CCombo model;
    CCombo exportLocation;
    List<NamedResource> models = Collections.emptyList();
    private Button overwrite;

    protected DrawingTemplateExportPage(ExportPlan model) {
        super("Export Diagram Template", "Define Export Location", null);
        this.exportModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("&Exported template:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the diagram template to export a state from.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        this.model.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DrawingTemplateExportPage.this.validatePage();
            }
        });
        new Label(container, 0).setText("&Target file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        this.exportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DrawingTemplateExportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DrawingTemplateExportPage.this.getShell(), 8192);
                dialog.setText("Choose Export Target File");
                String loc = DrawingTemplateExportPage.this.exportLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.diagramTemplate"});
                dialog.setFilterNames(new String[]{"Diagram Template (*.diagramTemplate)"});
                dialog.setOverwrite(false);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                DrawingTemplateExportPage.this.exportLocation.setText(file);
                DrawingTemplateExportPage.this.validatePage();
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(this.exportModel.overwrite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrawingTemplateExportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        List drawingTemplates = ISelectionUtils.getPossibleKeys((Object)this.exportModel.selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (drawingTemplates.size() != 1) {
            throw new RuntimeException();
        }
        Layer0 L0 = Layer0.getInstance((RequestProcessor)this.exportModel.sessionContext.getSession());
        String name = (String)this.exportModel.sessionContext.getSession().sync((ReadInterface)new RelatedValue((Resource)drawingTemplates.get(0), L0.HasName, (Binding)Bindings.STRING));
        this.exportModel.model = new NamedResource(name, (Resource)drawingTemplates.get(0));
        this.models = Collections.singletonList(this.exportModel.model);
        int i = 0;
        for (NamedResource m : this.models) {
            this.model.add(m.getName());
            this.model.setData(String.valueOf(i), (Object)m);
            if (m.equals((Object)this.exportModel.model)) {
                this.model.select(i);
            }
            ++i;
        }
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        if (this.exportLocation.getItemCount() > 0) {
            this.exportLocation.select(0);
        }
    }

    void validatePage() {
        if (this.exportModel.model == null) {
            this.setMessage("Select model to export from.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        String exportLoc = this.exportLocation.getText();
        if (exportLoc.isEmpty()) {
            this.setMessage("Select target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.isDirectory()) {
            this.setErrorMessage("The target is a directory.");
            this.setPageComplete(false);
            return;
        }
        File parent = file.getParentFile();
        if (parent == null || !parent.isDirectory()) {
            this.setErrorMessage("The target directory does not exist.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.exportLocation = file;
        this.exportModel.overwrite = this.overwrite.getSelection();
        this.setErrorMessage(null);
        this.setMessage("Export diagram template.");
        this.setPageComplete(true);
    }
}

